/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.db.DBAppenderTestFixture;
import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DBAppenderTest {
    LoggerContext lc;
    Logger logger;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;
    static DBAppenderTestFixture DB_APPENDER_TEST_FIXTURE;

    @BeforeClass
    public static void fixtureSetUp() throws SQLException {
        DB_APPENDER_TEST_FIXTURE = new DBAppenderTestFixture();
        DB_APPENDER_TEST_FIXTURE.setUp();
    }

    @AfterClass
    public static void fixtureTearDown() throws SQLException {
        DB_APPENDER_TEST_FIXTURE.tearDown();
    }

    @Before
    public void setUp() throws SQLException {
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.logger = this.lc.getLogger("root");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.lc);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.lc);
        this.connectionSource.setDriverClass("org.hsqldb.jdbcDriver");
        this.connectionSource.setUrl(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.url);
        this.connectionSource.setUser(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.user);
        this.connectionSource.setPassword(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
        this.appender.start();
    }

    @After
    public void tearDown() throws SQLException {
        this.logger = null;
        this.lc = null;
        this.appender = null;
        this.connectionSource = null;
    }

    @Test
    public void testAppendLoggingEvent() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        if (rs.next()) {
            Assert.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            Assert.assertEquals((Object)event.getFormattedMessage(), (Object)rs.getString(2));
            Assert.assertEquals((Object)event.getLoggerRemoteView().getName(), (Object)rs.getString(3));
            Assert.assertEquals((Object)event.getLevel().toString(), (Object)rs.getString(4));
            Assert.assertEquals((Object)event.getThreadName(), (Object)rs.getString(5));
            Assert.assertEquals((long)DBHelper.computeReferenceMask((LoggingEvent)event), (long)rs.getShort(6));
            CallerData callerData = event.getCallerData()[0];
            Assert.assertEquals((Object)callerData.getFileName(), (Object)rs.getString(7));
            Assert.assertEquals((Object)callerData.getClassName(), (Object)rs.getString(8));
            Assert.assertEquals((Object)callerData.getMethodName(), (Object)rs.getString(9));
        } else {
            Assert.fail((String)"No row was inserted in the database");
        }
        rs.close();
        stmt.close();
    }

    public void testAppendThrowable() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event_exception where event_id = 0");
        int i = 0;
        while (rs.next()) {
            Assert.assertEquals((Object)event.getThrowableProxy().getThrowableDataPointArray()[i].toString(), (Object)rs.getString(3));
            ++i;
        }
        rs.close();
        stmt.close();
    }

    public void testContextInfo() throws SQLException {
        LoggingEvent event = this.createLoggingEvent();
        this.lc.putProperty("testKey1", "testValue1");
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event_property where event_id = 0");
        Map map = this.appender.mergePropertyMaps(event);
        while (rs.next()) {
            String key = rs.getString(2);
            Assert.assertEquals(map.get(key), (Object)rs.getString(3));
        }
        rs.close();
        stmt.close();
    }

    public void testAppendMultipleEvents() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            LoggingEvent event = this.createLoggingEvent();
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        rs.close();
        stmt.close();
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", (Throwable)new Exception("test Ex"), null);
        return le;
    }
}

