/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.ContextNameConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.LineSeparatorConverter;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.RelativeTimeConverter;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.FormattingConverter;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;

public class ConverterTest {
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    LoggingEvent le;
    List<String> optionList = new ArrayList<String>();

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    Exception getException(String msg, Exception cause) {
        return new Exception(msg, cause);
    }

    @Before
    public void setUp() throws Exception {
        Exception rootEx = this.getException("Innermost", null);
        Exception nestedEx = this.getException("Nested", rootEx);
        Exception ex = new Exception("Bogus exception", nestedEx);
        this.le = this.makeLoggingEvent(ex);
    }

    @Test
    public void testLineOfCaller() {
        LineOfCallerConverter converter = new LineOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"69", (Object)buf.toString());
    }

    @Test
    public void testLevel() {
        LevelConverter converter = new LevelConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"INFO", (Object)buf.toString());
        converter = new LevelConverter();
        converter.setFormattingInfo(new FormatInfo(1, 1, true, false));
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"I", (Object)buf.toString());
    }

    @Test
    public void testThread() {
        ThreadConverter converter = new ThreadConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        String regex = "[mM]ain(\\sThread)?";
        Assert.assertTrue((boolean)buf.toString().matches(regex));
    }

    @Test
    public void testMessage() {
        MessageConverter converter = new MessageConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"Some message", (Object)buf.toString());
    }

    @Test
    public void testLineSeparator() {
        LineSeparatorConverter converter = new LineSeparatorConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)CoreConstants.LINE_SEPARATOR, (Object)buf.toString());
    }

    @Test
    public void testException() {
        ThrowableProxyConverter converter = new ThrowableProxyConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        converter = new ThrowableProxyConverter();
        this.optionList.add("3");
        converter.setOptionList(this.optionList);
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
    }

    @Test
    public void testLogger() {
        LoggerConverter converter = new LoggerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
        converter = new LoggerConverter();
        this.optionList.add("20");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"c.q.l.c.p.ConverterTest", (Object)buf.toString());
        converter = new LoggerConverter();
        this.optionList.clear();
        this.optionList.add("0");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"ConverterTest", (Object)buf.toString());
    }

    @Test
    public void testClass() {
        ClassOfCallerConverter converter = new ClassOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
    }

    @Test
    public void testMethodOfCaller() {
        MethodOfCallerConverter converter = new MethodOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"testMethodOfCaller", (Object)buf.toString());
    }

    @Test
    public void testFileOfCaller() {
        FileOfCallerConverter converter = new FileOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        Assert.assertEquals((Object)"ConverterTest.java", (Object)buf.toString());
    }

    @Test
    public void testCallerData() {
        CallerDataConverter converter = new CallerDataConverter();
        converter.start();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.add("2");
        this.optionList.add("XXX");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"XXX"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("+");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assert.fail((String)"buf is too short");
        }
    }

    @Test
    public void testRelativeTime() throws Exception {
        RelativeTimeConverter converter = new RelativeTimeConverter();
        StringBuffer buf0 = new StringBuffer();
        StringBuffer buf1 = new StringBuffer();
        LoggingEvent e0 = this.makeLoggingEvent(null);
        LoggingEvent e1 = this.makeLoggingEvent(null);
        converter.write(buf0, (Object)e0);
        converter.write(buf1, (Object)e1);
        Assert.assertEquals((Object)buf0.toString(), (Object)buf1.toString());
        int rt0 = Integer.parseInt(buf0.toString());
        if (rt0 < 50) {
            Assert.fail((String)("relative time should be > 50, but it is " + rt0));
        }
    }

    @Test
    public void testSyslogStart() throws Exception {
        SyslogStartConverter converter = new SyslogStartConverter();
        this.optionList.clear();
        this.optionList.add("MAIL");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)event);
        String expected = "<22>";
        Assert.assertTrue((boolean)buf.toString().startsWith(expected));
    }

    @Test
    public void testMDCConverter() throws Exception {
        MDC.clear();
        MDC.put((String)"someKey", (String)"someValue");
        MDCConverter converter = new MDCConverter();
        this.optionList.clear();
        this.optionList.add("someKey");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert(event);
        Assert.assertEquals((Object)"someValue", (Object)result);
    }

    @Test
    public void contextNameConverter() {
        ContextNameConverter converter = new ContextNameConverter();
        converter.setContext((Context)this.lc);
        this.lc.setName("aValue");
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((Object)event);
        Assert.assertEquals((Object)"aValue", (Object)result);
    }
}

