/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.ClassicGlobal;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.servlet.ContextDetachingSCL;
import ch.qos.logback.classic.util.MockInitialContext;
import ch.qos.logback.classic.util.MockInitialContextFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class ContextDetachingSCLTest {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";
    ContextDetachingSCL listener;

    @Before
    public void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        this.listener = new ContextDetachingSCL();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
    }

    @Test
    public void testDetach() {
        ContextJNDISelector selector = (ContextJNDISelector)StaticLoggerBinder.getSingleton().getContextSelector();
        this.listener.contextDestroyed(null);
        Assert.assertEquals((long)0L, (long)selector.getCount());
    }

    @Test
    public void testDetachWithMissingContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "tata");
        ContextJNDISelector selector = (ContextJNDISelector)StaticLoggerBinder.getSingleton().getContextSelector();
        Assert.assertEquals((Object)"tata", (Object)selector.getLoggerContext().getName());
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "titi");
        Assert.assertEquals((Object)"titi", (Object)selector.getLoggerContext().getName());
        this.listener.contextDestroyed(null);
        Assert.assertEquals((long)2L, (long)selector.getCount());
    }
}

