/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

public class SiftingAppenderTest {
    static String PREFIX = "src/test/input/joran/sift/";
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("root");

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void unsetDefaultValueProperty() throws JoranException {
        this.configure(PREFIX + "unsetDefaultValueProperty.xml");
        this.logger.debug("hello");
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        Assert.assertFalse((boolean)sa.isStarted());
    }

    @Test
    public void smoke() throws JoranException {
        this.configure(PREFIX + "smoke.xml");
        this.logger.debug("smoke");
        long timestamp = 0L;
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        ListAppender listAppender = (ListAppender)ha.getAppenderTracker().get("smoke", timestamp);
        StatusPrinter.print((Context)this.loggerContext);
        Assert.assertNotNull((Object)listAppender);
        List eventList = listAppender.list;
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        Assert.assertEquals((Object)"smoke", (Object)((LoggingEvent)eventList.get(0)).getMessage());
    }

    @Test
    public void testWholeCycle() throws JoranException {
        String mdcKey = "cycle";
        this.configure(PREFIX + "completeCycle.xml");
        MDC.put((String)mdcKey, (String)"a");
        this.logger.debug("smoke");
        long timestamp = System.currentTimeMillis();
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        ListAppender listAppender = (ListAppender)ha.getAppenderTracker().get("a", timestamp);
        StatusPrinter.print((Context)this.loggerContext);
        Assert.assertNotNull((Object)listAppender);
        List eventList = listAppender.list;
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        Assert.assertEquals((Object)"smoke", (Object)((LoggingEvent)eventList.get(0)).getMessage());
        MDC.remove((String)mdcKey);
        LoggingEvent le = new LoggingEvent("x", this.logger, Level.INFO, "hello", null, null);
        le.setTimeStamp(timestamp + 3600000L);
        ha.doAppend((Object)le);
        Assert.assertFalse((boolean)listAppender.isStarted());
        Assert.assertEquals((long)1L, (long)ha.getAppenderTracker().keyList().size());
        Assert.assertEquals((Object)"cycleDefault", ha.getAppenderTracker().keyList().get(0));
    }
}

