/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.util.TeztHelper;
import ch.qos.logback.core.util.SystemInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicCPDCTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void verify(ThrowableDataPoint[] tdpArray) {
        for (ThrowableDataPoint tdp : tdpArray) {
            StackTraceElementProxy step = tdp.getStackTraceElementProxy();
            if (step == null) continue;
            Assert.assertNotNull((Object)step.getClassPackagingData());
        }
    }

    @Test
    public void otherJD() {
        System.out.println(SystemInfo.getJavaVendor());
    }

    @Test
    public void integration() throws Exception {
    }

    @Test
    public void smoke() throws Exception {
        Throwable t = new Throwable("x");
        ThrowableProxy tp = new ThrowableProxy(t);
        PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
        ThrowableDataPoint[] tdpArray = tp.getThrowableDataPointArray();
        pdc.calculate(tdpArray);
        this.verify(tdpArray);
        tp.fullDump();
    }

    @Test
    public void nested() throws Exception {
        Throwable t = TeztHelper.makeNestedException(3);
        ThrowableProxy tp = new ThrowableProxy(t);
        PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
        ThrowableDataPoint[] tdpArray = tp.getThrowableDataPointArray();
        pdc.calculate(tdpArray);
        this.verify(tdpArray);
    }

    public void doCalculateClassPackagingData(boolean withClassPackagingCalculation) {
        try {
            throw new Exception("testing");
        }
        catch (Throwable e) {
            ThrowableProxy tp = new ThrowableProxy(e);
            if (withClassPackagingCalculation) {
                PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
                ThrowableDataPoint[] tdpArray = tp.getThrowableDataPointArray();
                pdc.calculate(tdpArray);
            }
            return;
        }
    }

    double loop(int len, boolean withClassPackagingCalculation) {
        long start = System.nanoTime();
        for (int i = 0; i < len; ++i) {
            this.doCalculateClassPackagingData(withClassPackagingCalculation);
        }
        return (1.0 * (double)System.nanoTime() - (double)start) / (double)len / 1000.0;
    }

    @Test
    public void perfTest() {
        int len = 1000;
        this.loop(len, false);
        this.loop(len, true);
        double d0 = this.loop(len, false);
        System.out.println("without packaging info " + d0 + " microseconds");
        double d1 = this.loop(len, true);
        System.out.println("with    packaging info " + d1 + " microseconds");
        int slackFactor = 8;
        if (!SystemInfo.getJavaVendor().contains("Sun")) {
            slackFactor = 10;
        }
        Assert.assertTrue((String)("computing class packaging data (" + d1 + ") should have been less than " + slackFactor + " times the time it takes to process an exception " + d0 * (double)slackFactor), (d0 * (double)slackFactor > d1 ? 1 : 0) != 0);
    }
}

