/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.BasicContextListener;
import ch.qos.logback.classic.spi.LoggerContextListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContextListenerTest {
    LoggerContext context;
    BasicContextListener listener;

    @Before
    public void setUp() throws Exception {
        this.context = new LoggerContext();
        this.listener = new BasicContextListener();
        this.context.addListener((LoggerContextListener)this.listener);
    }

    @Test
    public void testNotifyOnReset() {
        this.context.reset();
        Assert.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assert.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStopResistant() {
        this.listener.setResetResistant(true);
        this.context.stop();
        Assert.assertEquals((Object)((Object)BasicContextListener.UpdateType.STOP), (Object)((Object)this.listener.updateType));
        Assert.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStopNotResistant() {
        this.context.stop();
        Assert.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assert.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStart() {
        this.context.start();
        Assert.assertEquals((Object)((Object)BasicContextListener.UpdateType.START), (Object)((Object)this.listener.updateType));
        Assert.assertEquals((Object)this.listener.context, (Object)this.context);
    }
}

