/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LuckyCharms;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class LoggingEventSerializationTest {
    LoggerContext lc;
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    ObjectInputStream inputStream;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("testContext");
        this.logger = this.lc.getLogger("root");
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.logger = null;
        this.oos.close();
    }

    @Test
    public void smoke() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
    }

    @Test
    public void context() throws Exception {
        this.lc.putProperty("testKey", "testValue");
        LoggingEvent event = this.createLoggingEvent();
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
        LoggerRemoteView loggerRemoteView = remoteEvent.getLoggerRemoteView();
        Assert.assertNotNull((Object)loggerRemoteView);
        Assert.assertEquals((Object)"root", (Object)loggerRemoteView.getName());
        LoggerContextRemoteView loggerContextRemoteView = loggerRemoteView.getLoggerContextView();
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"testContext", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void MDC() throws Exception {
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event = this.createLoggingEvent();
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void updatedMDC() throws Exception {
        MDC.put((String)"key", (String)"testValue");
        LoggingEvent event1 = this.createLoggingEvent();
        this.oos.writeObject(event1);
        MDC.put((String)"key", (String)"updatedTestValue");
        LoggingEvent event2 = this.createLoggingEvent();
        this.oos.writeObject(event2);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        this.inputStream.readObject();
        LoggingEvent remoteEvent2 = (LoggingEvent)this.inputStream.readObject();
        Map MDCPropertyMap = remoteEvent2.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get("key"));
    }

    @Test
    public void nonSerializableParameters() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        LuckyCharms lucky0 = new LuckyCharms(0);
        event.setArgumentArray(new Object[]{lucky0, null});
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assert.assertNotNull((Object)aa);
        Assert.assertEquals((long)2L, (long)aa.length);
        Assert.assertEquals((Object)"LC(0)", (Object)aa[0]);
        Assert.assertNull((Object)aa[1]);
    }

    @Test
    public void _Throwable() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        Throwable throwable = new Throwable("just testing");
        ThrowableProxy tp = new ThrowableProxy(throwable);
        event.setThrowableProxy(tp);
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
    }

    @Test
    public void extendendeThrowable() throws Exception {
        LoggingEvent event = this.createLoggingEvent();
        Throwable throwable = new Throwable("just testing");
        ThrowableProxy tp = new ThrowableProxy(throwable);
        event.setThrowableProxy(tp);
        tp.calculatePackagingData();
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
    }

    @Test
    public void serializeLargeArgs() throws Exception {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 100000; ++i) {
            buffer.append("X");
        }
        String largeString = buffer.toString();
        Object[] argArray = new Object[]{new LuckyCharms(2), largeString};
        LoggingEvent event = this.createLoggingEvent();
        event.setArgumentArray(argArray);
        LoggingEvent remoteEvent = this.writeAndRead(event);
        this.checkForEquality(event, remoteEvent);
        Object[] aa = remoteEvent.getArgumentArray();
        Assert.assertNotNull((Object)aa);
        Assert.assertEquals((long)2L, (long)aa.length);
        String stringBack = (String)aa[1];
        Assert.assertEquals((Object)largeString, (Object)stringBack);
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
        return le;
    }

    private void checkForEquality(LoggingEvent original, LoggingEvent afterSerialization) {
        Assert.assertEquals((Object)original.getLevel(), (Object)afterSerialization.getLevel());
        Assert.assertEquals((Object)original.getFormattedMessage(), (Object)afterSerialization.getFormattedMessage());
        Assert.assertEquals((Object)original.getMessage(), (Object)afterSerialization.getMessage());
        System.out.println();
        Assert.assertEquals((Object)original.getThrowableProxy(), (Object)afterSerialization.getThrowableProxy());
    }

    private LoggingEvent writeAndRead(LoggingEvent event) throws IOException, ClassNotFoundException {
        this.oos.writeObject(event);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        return (LoggingEvent)this.inputStream.readObject();
    }
}

