/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.TrivialStatusListener;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class InitializationTest {
    org.slf4j.Logger logger = LoggerFactory.getLogger(InitializationTest.class);
    LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
    Logger root = (Logger)LoggerFactory.getLogger((String)"root");

    @Before
    public void setUp() throws Exception {
        this.logger.debug("Hello-didily-odily");
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("logback.configurationFile");
        System.clearProperty("logback.statusListenerClass");
        this.lc.reset();
    }

    @Test
    @Ignore
    public void atoconfig() {
        Appender appender = this.root.getAppender("STDOUT");
        Assert.assertNotNull((Object)appender);
        Assert.assertTrue((boolean)(appender instanceof ConsoleAppender));
    }

    @Test
    @Ignore
    public void reset() throws JoranException {
        new ContextInitializer(this.lc).autoConfig();
        Appender appender = this.root.getAppender("STDOUT");
        Assert.assertNotNull((Object)appender);
        Assert.assertTrue((boolean)(appender instanceof ConsoleAppender));
        this.lc.stop();
        appender = this.root.getAppender("STDOUT");
        Assert.assertNull((Object)appender);
    }

    @Test
    public void autoConfigFromSystemProperties() throws JoranException {
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        this.doAutoConfigFromSystemProperties("autoConfigAsResource.xml");
        this.doAutoConfigFromSystemProperties("file:src/test/input/autoConfig.xml");
    }

    public void doAutoConfigFromSystemProperties(String val) throws JoranException {
        System.setProperty("logback.configurationFile", val);
        new ContextInitializer(this.lc).autoConfig();
        Appender appender = this.root.getAppender("AUTO_BY_SYSTEM_PROPERTY");
        Assert.assertNotNull((Object)appender);
    }

    @Test
    public void autoStatusListener() throws JoranException {
        System.setProperty("logback.statusListenerClass", TrivialStatusListener.class.getName());
        List sll = this.lc.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertEquals((long)0L, (long)sll.size());
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        sll = this.lc.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertTrue((String)(sll.size() + " should be 1"), (sll.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void autoOnConsoleStatusListener() throws JoranException {
        System.setProperty("logback.statusListenerClass", "SYSOUT");
        List sll = this.lc.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertEquals((long)0L, (long)sll.size());
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        sll = this.lc.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertTrue((String)(sll.size() + " should be 1"), (sll.size() == 1 ? 1 : 0) != 0);
    }
}

