/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Foo;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LoggerSerializationTest {
    LoggerContext lc;
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    ObjectInputStream inputStream;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("testContext");
        this.logger = this.lc.getLogger(LoggerSerializationTest.class);
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.logger = null;
    }

    @Test
    public void serialization() throws IOException, ClassNotFoundException {
        Foo foo = new Foo(this.logger);
        foo.doFoo();
        Foo fooBack = this.writeAndRead(foo);
        fooBack.doFoo();
    }

    private Foo writeAndRead(Foo foo) throws IOException, ClassNotFoundException {
        this.oos.writeObject(foo);
        this.oos.flush();
        this.oos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new ObjectInputStream(bis);
        Foo fooBack = (Foo)this.inputStream.readObject();
        this.inputStream.close();
        return fooBack;
    }
}

