/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.GEventEvaluator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.helpers.BogoPerf;

public class GEventEvaluatorTest {
    LoggerContext context = new LoggerContext();
    StatusChecker statusChecker = new StatusChecker((Context)this.context);
    int LEN = 100000;
    Logger logger = this.context.getLogger(this.getClass());
    Marker markerA = MarkerFactory.getMarker((String)"A");

    LoggingEvent makeEvent(String msg) {
        return this.makeEvent(Level.DEBUG, msg, null, null);
    }

    LoggingEvent makeEvent(Level level, String msg, Throwable t, Object[] argArray) {
        return new LoggingEvent(this.getClass().getName(), this.logger, level, msg, t, argArray);
    }

    void doEvaluateAndCheck(String expression, ILoggingEvent event, boolean expected) throws EvaluationException {
        GEventEvaluator gee = new GEventEvaluator();
        gee.setContext((Context)this.context);
        gee.setExpression(expression);
        gee.start();
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        Assert.assertTrue((boolean)this.statusChecker.isErrorFree());
        boolean result = gee.evaluate(event);
        junit.framework.Assert.assertEquals((boolean)expected, (boolean)result);
    }

    @Test
    public void smoke() throws EvaluationException {
        this.doEvaluateAndCheck("1==1", null, true);
    }

    @Test
    public void event() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        event.getLoggerContextVO();
        this.doEvaluateAndCheck("e.message == 'x'", (ILoggingEvent)event, true);
    }

    @Test
    public void msgRegex() throws EvaluationException {
        LoggingEvent event = this.makeEvent("Hello world");
        this.doEvaluateAndCheck("e.message =~ /xyz|wor/", (ILoggingEvent)event, true);
        this.doEvaluateAndCheck("e.message ==~ /xyz|wor/", (ILoggingEvent)event, false);
    }

    @Test
    public void level() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        this.doEvaluateAndCheck("e.level == DEBUG", (ILoggingEvent)event, true);
    }

    @Test
    public void nullMarker() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        this.doEvaluateAndCheck("e.marker?.name == 'YELLOW'", (ILoggingEvent)event, false);
    }

    @Test
    public void marker() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        event.setMarker(this.markerA);
        this.doEvaluateAndCheck("e.marker?.name == 'A'", (ILoggingEvent)event, true);
    }

    @Test
    public void nullMDC() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        this.doEvaluateAndCheck("e.mdc?.get('key') == 'val'", (ILoggingEvent)event, false);
    }

    @Test
    public void mdc() throws EvaluationException {
        MDC.put((String)"key", (String)"val");
        LoggingEvent event = this.makeEvent("x");
        this.doEvaluateAndCheck("e.mdc['key'] == 'val'", (ILoggingEvent)event, true);
        MDC.clear();
    }

    @Test
    public void callerData() throws EvaluationException {
        LoggingEvent event = this.makeEvent("x");
        this.doEvaluateAndCheck("e.callerData.find{ it.className =~ /junit/ }", (ILoggingEvent)event, true);
    }

    double loop(GEventEvaluator gee) throws EvaluationException {
        long start = System.nanoTime();
        LoggingEvent event = this.makeEvent("x");
        for (int i = 0; i < this.LEN; ++i) {
            gee.evaluate((ILoggingEvent)event);
        }
        long end = System.nanoTime();
        return (end - start) / (long)this.LEN;
    }

    @Test
    public void perfTest() throws EvaluationException {
        GEventEvaluator gee = new GEventEvaluator();
        gee.setContext((Context)this.context);
        gee.setExpression("event.timeStamp < 100 && event.message != 'xx' ");
        gee.start();
        this.loop(gee);
        this.loop(gee);
        double avgDuration = this.loop(gee);
        long referencePerf = 500L;
        BogoPerf.assertDuration((double)avgDuration, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
        System.out.println("Average duration " + avgDuration);
    }
}

