/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import java.text.SimpleDateFormat;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SelectiveDateFormattingRunnable
extends RunnableWithCounterAndDone {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    FormattingModel model;
    static long CACHE = 0L;
    static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    static final DateTimeFormatter JODA = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSS");

    SelectiveDateFormattingRunnable(FormattingModel model) {
        this.model = model;
    }

    public void run() {
        switch (this.model) {
            case SDF: {
                this.sdfRun();
                break;
            }
            case JODA: {
                this.jodaRun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sdfRun() {
        do {
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                long now = System.currentTimeMillis();
                if (CACHE != now) {
                    CACHE = now;
                    SDF.format(now);
                }
            }
            ++this.counter;
        } while (!this.done);
    }

    void jodaRun() {
        do {
            long now;
            if (SelectiveDateFormattingRunnable.isCacheStale(now = System.currentTimeMillis())) {
                JODA.print(now);
            }
            ++this.counter;
        } while (!this.done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCacheStale(long now) {
        DateTimeFormatter dateTimeFormatter = JODA;
        synchronized (dateTimeFormatter) {
            if (CACHE != now) {
                CACHE = now;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FormattingModel {
        SDF,
        JODA;

    }
}

