/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.util.SystemInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class MDCConverterTest {
    LoggerContext lc;
    MDCConverter converter;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MDCConverter();
        this.converter.start();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void testConverWithOneEntry() {
        MDC.clear();
        MDC.put((String)"testKey", (String)"testValue");
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        Assert.assertEquals((Object)"testKey=testValue", (Object)result);
    }

    @Test
    public void testConverWithMultipleEntries() {
        MDC.clear();
        MDC.put((String)"testKey", (String)"testValue");
        MDC.put((String)"testKey2", (String)"testValue2");
        ILoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        if (SystemInfo.getJavaVendor().contains("IBM")) {
            Assert.assertEquals((Object)"testKey2=testValue2, testKey=testValue", (Object)result);
        } else {
            Assert.assertEquals((Object)"testKey=testValue, testKey2=testValue2", (Object)result);
        }
    }

    private ILoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
        return le;
    }
}

