/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.util.CopyOnInheritThreadLocal;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackMDCAdapterTest {
    static final String A_SUFFIX = "A_SUFFIX";
    int diff = RandomUtil.getPositiveInt();

    @Test
    public void lbclassic77() throws InterruptedException {
        LogbackMDCAdapter lma = new LogbackMDCAdapter();
        HashMap<String, String> parentHM = this.getHashMapFromMDCAdapter(lma);
        Assert.assertNull(parentHM);
        ChildThreadForMDCAdapter childThread = new ChildThreadForMDCAdapter(lma);
        childThread.start();
        childThread.join();
        Assert.assertTrue((boolean)childThread.successul);
        Assert.assertNull(childThread.childHM);
    }

    @Test
    public void removeForNullKey() {
        LogbackMDCAdapter lma = new LogbackMDCAdapter();
        lma.remove(null);
    }

    @Test
    public void removeInexistnetKey() {
        LogbackMDCAdapter lma = new LogbackMDCAdapter();
        lma.remove("abcdlw0");
    }

    @Test
    public void copyOnInheritence() throws InterruptedException {
        String mdcKey = "x" + this.diff;
        String otherMDCKey = "o" + this.diff;
        MDC.put((String)mdcKey, (String)(mdcKey + A_SUFFIX));
        HashMap<String, String> parentHM = this.getHashMapFromMDC();
        ChildThreadForMDC childThread = new ChildThreadForMDC(mdcKey, otherMDCKey);
        childThread.start();
        childThread.join();
        Assert.assertNull((Object)MDC.get((String)otherMDCKey));
        Assert.assertTrue((boolean)childThread.successul);
        Assert.assertTrue((parentHM != childThread.childHM ? 1 : 0) != 0);
    }

    HashMap<String, String> getHashMapFromMDCAdapter(LogbackMDCAdapter lma) {
        CopyOnInheritThreadLocal copyOnInheritThreadLocal = lma.copyOnInheritThreadLocal;
        return (HashMap)copyOnInheritThreadLocal.get();
    }

    HashMap<String, String> getHashMapFromMDC() {
        LogbackMDCAdapter lma = (LogbackMDCAdapter)MDC.getMDCAdapter();
        CopyOnInheritThreadLocal copyOnInheritThreadLocal = lma.copyOnInheritThreadLocal;
        return (HashMap)copyOnInheritThreadLocal.get();
    }

    class ChildThreadForMDC
    extends Thread {
        String mdcKey;
        String otherMDCKey;
        boolean successul;
        HashMap<String, String> childHM;

        ChildThreadForMDC(String mdcKey, String otherMDCKey) {
            this.mdcKey = mdcKey;
            this.otherMDCKey = otherMDCKey;
        }

        public void run() {
            this.childHM = LogbackMDCAdapterTest.this.getHashMapFromMDC();
            MDC.put((String)this.otherMDCKey, (String)(this.otherMDCKey + LogbackMDCAdapterTest.A_SUFFIX));
            Assert.assertNotNull((Object)MDC.get((String)this.mdcKey));
            Assert.assertEquals((Object)(this.mdcKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)MDC.get((String)this.mdcKey));
            Assert.assertEquals((Object)(this.otherMDCKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)MDC.get((String)this.otherMDCKey));
            this.successul = true;
        }
    }

    class ChildThreadForMDCAdapter
    extends Thread {
        LogbackMDCAdapter logbackMDCAdapter;
        boolean successul;
        HashMap<String, String> childHM;

        ChildThreadForMDCAdapter(LogbackMDCAdapter logbackMDCAdapter) {
            this.logbackMDCAdapter = logbackMDCAdapter;
        }

        public void run() {
            this.childHM = LogbackMDCAdapterTest.this.getHashMapFromMDCAdapter(this.logbackMDCAdapter);
            this.logbackMDCAdapter.get("");
            this.successul = true;
        }
    }
}

