/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBCORE63
extends Thread {
    private static final String LOGGER_CONFIGURATION_FILE = "./src/test/input/issue/lbcore63.xml";
    private final Logger logger = LoggerFactory.getLogger(LBCORE63.class);
    private final long start = new Date().getTime();

    public LBCORE63() throws JoranException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        lc.reset();
        configurator.setContext((Context)lc);
        configurator.doConfigure(LOGGER_CONFIGURATION_FILE);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }

    public void start() {
        ScheduledThreadPoolExecutor ex1 = new ScheduledThreadPoolExecutor(1);
        ScheduledThreadPoolExecutor ex2 = new ScheduledThreadPoolExecutor(1);
        ScheduledThreadPoolExecutor ex3 = new ScheduledThreadPoolExecutor(1);
        ScheduledThreadPoolExecutor ex4 = new ScheduledThreadPoolExecutor(1);
        ScheduledThreadPoolExecutor ex5 = new ScheduledThreadPoolExecutor(1);
        ex1.scheduleAtFixedRate(new Task("EX1"), 10L, 10L, TimeUnit.MICROSECONDS);
        ex2.scheduleAtFixedRate(new Task("EX2"), 10L, 10L, TimeUnit.MICROSECONDS);
        ex3.scheduleAtFixedRate(new Task("EX3"), 10L, 10L, TimeUnit.MICROSECONDS);
        ex4.scheduleAtFixedRate(new Task("EX4"), 10L, 10L, TimeUnit.MICROSECONDS);
        ex5.scheduleAtFixedRate(new Task("EX5"), 10L, 10L, TimeUnit.MICROSECONDS);
        super.start();
    }

    public void run() {
        try {
            while (true) {
                this.logger.debug("[MAIN] {}", (Object)(new Date().getTime() - this.start));
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            this.logger.info("[MAIN]: Interrupted: {}", (Object)e.getMessage());
            return;
        }
    }

    public static void main(String[] args) {
        try {
            LBCORE63 main = new LBCORE63();
            main.start();
        }
        catch (JoranException e) {
            System.out.println("Failed to load application: " + e.getMessage());
        }
    }

    class Task
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Task.class);
        final String name;
        private final long start;
        int counter = 0;
        public long diff;

        public Task(String name) {
            this.name = name;
            this.start = new Date().getTime();
        }

        public void run() {
            ++this.counter;
            this.diff = new Date().getTime() - this.start;
            this.logger.debug("counter={}", (Object)this.counter);
        }
    }
}

