/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.DebugUsersTurboFilter;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.StringListAppender;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

public class JoranConfiguratorTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("ROOT");

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void simpleList() throws JoranException {
        this.configure("src/test/input/joran/simpleList.xml");
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("ROOT");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)msg, (Object)le.getMessage());
    }

    @Test
    public void level() throws JoranException {
        this.configure("src/test/input/joran/simpleLevel.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
    }

    @Test
    public void rootLoggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "INFO");
        this.configure("src/test/input/joran/rootLevelByProperty.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void loggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "DEBUG");
        this.configure("src/test/input/joran/loggerLevelByProperty.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void appenderRefSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.appenderRef";
        System.setProperty("logback.appenderRef", "A");
        this.configure("src/test/input/joran/appenderRefByProperty.xml");
        Logger logger = this.loggerContext.getLogger("ch.qos.logback.classic.joran");
        ListAppender listAppender = (ListAppender)logger.getAppender("A");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        logger.info("hello world");
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        System.clearProperty("logback.appenderRef");
    }

    @Test
    public void statusListener() throws JoranException {
        this.configure("src/test/input/joran/statusListener.xml");
    }

    @Test
    public void contextRename() throws JoranException {
        this.loggerContext.setName("default");
        this.configure("src/test/input/joran/contextRename.xml");
        Assert.assertEquals((Object)"wombat", (Object)this.loggerContext.getName());
    }

    @Test
    public void eval() throws JoranException {
        this.configure("src/test/input/joran/callerData.xml");
        String msg = "hello world";
        this.logger.debug("toto");
        this.logger.debug(msg);
        StringListAppender slAppender = (StringListAppender)this.loggerContext.getLogger("root").getAppender("STR_LIST");
        Assert.assertNotNull((Object)slAppender);
        Assert.assertEquals((long)2L, (long)slAppender.strList.size());
        Assert.assertTrue((boolean)((String)slAppender.strList.get(0)).contains(" DEBUG - toto"));
        String str1 = (String)slAppender.strList.get(1);
        Assert.assertTrue((boolean)str1.contains("Caller+0"));
        Assert.assertTrue((boolean)str1.contains(" DEBUG - hello world"));
    }

    @Test
    public void turboFilter() throws JoranException {
        this.configure("src/test/input/joran/turbo.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assert.assertTrue((boolean)(filter instanceof NOPTurboFilter));
    }

    @Test
    public void testTurboFilterWithStringList() throws JoranException {
        this.configure("src/test/input/joran/turbo2.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assert.assertTrue((boolean)(filter instanceof DebugUsersTurboFilter));
        DebugUsersTurboFilter dutf = (DebugUsersTurboFilter)filter;
        Assert.assertEquals((long)2L, (long)dutf.getUsers().size());
    }

    @Test
    public void testLevelFilter() throws JoranException {
        this.configure("src/test/input/joran/levelFilter.xml");
        this.logger.warn("hello");
        this.logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        ILoggingEvent back = (ILoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        Assert.assertEquals((Object)"hello", (Object)back.getMessage());
    }

    @Test
    public void testEvaluatorFilter() throws JoranException {
        this.configure("src/test/input/joran/evaluatorFilter.xml");
        this.logger.warn("hello");
        this.logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        ILoggingEvent back = (ILoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        Assert.assertEquals((Object)"hello", (Object)back.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold2() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold2.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        MDC.put((String)"userId", (String)"user3");
        this.logger.debug("hello user3");
        Assert.assertEquals((long)2L, (long)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)"hello user1", (Object)le.getMessage());
        le = (ILoggingEvent)listAppender.list.get(1);
        Assert.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }

    @Test
    public void scan1() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/scan1.xml";
        this.configure(configFileAsStr);
        File file = new File(configFileAsStr);
        file.setLastModified(System.currentTimeMillis());
        Thread.sleep(100L);
        for (int i = 0; i < 16; ++i) {
            this.logger.debug("after " + i);
        }
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.isErrorFree());
        Assert.assertTrue((boolean)checker.containsMatch("Resetting and reconfiguring context"));
    }

    @Test
    public void timestamp() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/timestamp.xml";
        this.configure(configFileAsStr);
        String r = this.loggerContext.getProperty("testTimestamp");
        Assert.assertNotNull((Object)r);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String expected = sdf.format(new Date());
        Assert.assertEquals((String)("expected \"" + expected + "\" but got " + r), (Object)expected, (Object)r);
    }

    @Test
    public void encoderCharset() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/encoderCharset.xml";
        this.configure(configFileAsStr);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CONSOLE");
        Assert.assertNotNull((Object)consoleAppender);
        LayoutWrappingEncoder encoder = (LayoutWrappingEncoder)consoleAppender.getEncoder();
        Assert.assertEquals((Object)"UTF-8", (Object)encoder.getCharset().displayName());
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.isErrorFree());
    }

    void verifyJULLevel(String loggerName, Level expectedLevel) {
        LogManager lm = LogManager.getLogManager();
        java.util.logging.Logger julLogger = JULHelper.asJULLogger((String)loggerName);
        java.util.logging.Level julLevel = julLogger.getLevel();
        if (expectedLevel == null) {
            Assert.assertNull((Object)julLevel);
        } else {
            Assert.assertEquals((Object)JULHelper.asJULLevel((Level)expectedLevel), (Object)julLevel);
        }
    }

    @Test
    public void levelChangePropagator0() throws JoranException, IOException, InterruptedException {
        java.util.logging.Logger.getLogger("xx").setLevel(java.util.logging.Level.INFO);
        String configFileAsStr = "src/test/input/joran//jul/levelChangePropagator0.xml";
        this.configure(configFileAsStr);
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.isErrorFree());
        this.verifyJULLevel("xx", null);
        this.verifyJULLevel("a.b.c", Level.WARN);
        this.verifyJULLevel("ROOT", Level.TRACE);
    }

    @Test
    public void levelChangePropagator1() throws JoranException, IOException, InterruptedException {
        java.util.logging.Logger.getLogger("xx").setLevel(java.util.logging.Level.INFO);
        String configFileAsStr = "src/test/input/joran//jul/levelChangePropagator1.xml";
        this.configure(configFileAsStr);
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.isErrorFree());
        this.verifyJULLevel("xx", Level.INFO);
        this.verifyJULLevel("a.b.c", Level.WARN);
        this.verifyJULLevel("ROOT", Level.TRACE);
    }
}

