/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import javax.mail.Address;
import javax.mail.MessagingException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DilutedSMTPAppenderTest {
    SMTPAppender appender;
    CyclicBufferTracker cbTracker;
    CyclicBuffer cb;

    @Before
    public void setUp() throws Exception {
        LoggerContext lc = new LoggerContext();
        this.appender = new SMTPAppender();
        this.cbTracker = this.appender.getCyclicBufferTracker();
        this.cb = this.cbTracker.get("", 0L);
        this.appender.setContext((Context)lc);
        this.appender.setName("smtp");
        this.appender.setFrom("user@host.dom");
        this.appender.setLayout(DilutedSMTPAppenderTest.buildLayout(lc));
        this.appender.setSMTPHost("mail2.qos.ch");
        this.appender.setSubject("logging report");
        this.appender.addTo("sebastien.nospam@qos.ch");
        this.appender.start();
    }

    private static Layout<ILoggingEvent> buildLayout(LoggerContext lc) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader("Some header\n");
        layout.setPattern("%-4relative [%thread] %-5level %class - %msg%n");
        layout.setFileFooter("Some footer");
        layout.start();
        return layout;
    }

    @After
    public void tearDown() throws Exception {
        this.appender = null;
    }

    @Test
    public void testStart() {
        try {
            Address[] addressArray = this.appender.getMessage().getFrom();
            Address address = addressArray[0];
            Assert.assertEquals((Object)"user@host.dom", (Object)address.toString());
            addressArray = null;
            address = null;
            addressArray = this.appender.getMessage().getAllRecipients();
            address = addressArray[0];
            Assert.assertEquals((Object)"sebastien.nospam@qos.ch", (Object)address.toString());
            Assert.assertEquals((Object)"logging report", (Object)this.appender.getSubject());
            Assert.assertTrue((boolean)this.appender.isStarted());
        }
        catch (MessagingException ex) {
            Assert.fail((String)"Unexpected exception.");
        }
    }

    @Test
    public void testAppendNonTriggeringEvent() {
        LoggingEvent event = new LoggingEvent();
        event.setThreadName("thead name");
        event.setLevel(Level.DEBUG);
        this.appender.subAppend(this.cb, (ILoggingEvent)event);
        Assert.assertEquals((long)1L, (long)this.cb.length());
    }

    @Test
    public void testEntryConditionsCheck() {
        this.appender.checkEntryConditions();
        Assert.assertEquals((long)0L, (long)this.appender.getContext().getStatusManager().getCount());
    }

    @Test
    public void testEntryConditionsCheckNoMessage() {
        this.appender.setMessage(null);
        this.appender.checkEntryConditions();
        Assert.assertEquals((long)1L, (long)this.appender.getContext().getStatusManager().getCount());
    }

    @Test
    public void testTriggeringPolicy() {
        this.appender.setEvaluator(null);
        this.appender.checkEntryConditions();
        Assert.assertEquals((long)1L, (long)this.appender.getContext().getStatusManager().getCount());
    }

    @Test
    public void testEntryConditionsCheckNoLayout() {
        this.appender.setLayout(null);
        this.appender.checkEntryConditions();
        Assert.assertEquals((long)1L, (long)this.appender.getContext().getStatusManager().getCount());
    }
}

