/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.contention.MultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.testUtil.Env;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.junit.Before;
import org.junit.Test;

public class ReconfigurePerf {
    static final int THREAD_COUNT = 50;
    static final int LOOP_LEN = 1000000;
    static final String CONF_FILE_AS_STR = "src/test/input/turbo/scan_perf.xml";
    static final int DEFAULT_SLEEP_BETWEEN_UPDATES = 110;
    int sleepBetweenUpdates = 110;
    static int totalTestDuration;
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    MultiThreadedHarness harness;

    @Before
    public void setUp() {
        if (Env.isLinux()) {
            this.sleepBetweenUpdates = 850;
            totalTestDuration = this.sleepBetweenUpdates * 5;
        } else {
            totalTestDuration = this.sleepBetweenUpdates * 10;
        }
        this.harness = new MultiThreadedHarness((long)totalTestDuration);
    }

    void configure(File file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    RunnableWithCounterAndDone[] buildRunnableArray() {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[50];
        for (int i = 0; i < 50; ++i) {
            rArray[i] = new LoggingRunnable(this.logger);
        }
        return rArray;
    }

    @Test
    public void scan1() throws JoranException, IOException, InterruptedException {
        File file = new File(CONF_FILE_AS_STR);
        this.configure(file);
        this.doRun();
        this.doRun();
        this.doRun();
        System.out.println("ENTER :");
        System.in.read();
        this.doRun();
    }

    void doRun() throws InterruptedException {
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray();
        this.harness.execute(runnableArray);
    }

    ReconfigureOnChangeFilter initROCF() throws MalformedURLException {
        ReconfigureOnChangeFilter rocf = new ReconfigureOnChangeFilter();
        rocf.setContext((Context)this.loggerContext);
        File file = new File(CONF_FILE_AS_STR);
        this.loggerContext.putObject(CoreConstants.URL_OF_LAST_CONFIGURATION_VIA_JORAN, (Object)file.toURI().toURL());
        rocf.start();
        return rocf;
    }

    public double directLoop(ReconfigureOnChangeFilter rocf) {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            rocf.decide(null, this.logger, Level.DEBUG, " ", null, null);
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    void addInfo(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new InfoStatus(msg, o));
    }
}

