/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db.names;

import ch.qos.logback.classic.db.names.ColumnName;
import ch.qos.logback.classic.db.names.SimpleDBNameResolver;
import ch.qos.logback.classic.db.names.TableName;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SimpleDBNameResolverTest {
    private SimpleDBNameResolver nameResolver;

    @Before
    public void setUp() throws Exception {
        this.nameResolver = new SimpleDBNameResolver();
    }

    @Test
    public void shouldReturnTableNameWithPrefix() throws Exception {
        this.nameResolver.setTableNamePrefix("tp_");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("tp_logging_event");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("thread_name");
    }

    @Test
    public void shouldReturnTableNameWithSuffix() throws Exception {
        this.nameResolver.setTableNameSuffix("_ts");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("logging_event_ts");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("thread_name");
    }

    @Test
    public void shouldReturnTableNameWithBothPrefixAndSuffix() throws Exception {
        this.nameResolver.setTableNamePrefix("tp_");
        this.nameResolver.setTableNameSuffix("_ts");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("tp_logging_event_ts");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("thread_name");
    }

    @Test
    public void shouldReturnColumnNameWithPrefix() throws Exception {
        this.nameResolver.setColumnNamePrefix("cp_");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("logging_event");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("cp_thread_name");
    }

    @Test
    public void shouldReturnColumnNameWithSuffix() throws Exception {
        this.nameResolver.setColumnNameSuffix("_cs");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("logging_event");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("thread_name_cs");
    }

    @Test
    public void shouldReturnColumnNameWithBothPrefixAndSuffix() throws Exception {
        this.nameResolver.setColumnNamePrefix("cp_");
        this.nameResolver.setColumnNameSuffix("_cs");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("logging_event");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("cp_thread_name_cs");
    }

    @Test
    public void shouldReturnTableAndColumnNamesWithBothPrefixAndSuffix() throws Exception {
        this.nameResolver.setTableNamePrefix("tp_");
        this.nameResolver.setTableNameSuffix("_ts");
        this.nameResolver.setColumnNamePrefix("cp_");
        this.nameResolver.setColumnNameSuffix("_cs");
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("tp_logging_event_ts");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("cp_thread_name_cs");
    }

    @Test
    public void shouldHandleNullsAsEmptyStrings() throws Exception {
        this.nameResolver.setTableNamePrefix(null);
        this.nameResolver.setTableNameSuffix(null);
        this.nameResolver.setColumnNamePrefix(null);
        this.nameResolver.setColumnNameSuffix(null);
        Assertions.assertThat((String)this.nameResolver.getTableName((Enum)TableName.LOGGING_EVENT)).isEqualTo("logging_event");
        Assertions.assertThat((String)this.nameResolver.getColumnName((Enum)ColumnName.THREAD_NAME)).isEqualTo("thread_name");
    }
}

