/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.sift.MDCBasedDiscriminator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class MDCBasedDiscriminatorTest {
    static String DEFAULT_VAL = "DEFAULT_VAL";
    MDCBasedDiscriminator discriminator = new MDCBasedDiscriminator();
    LoggerContext context = new LoggerContext();
    Logger logger = this.context.getLogger(this.getClass());
    int diff = RandomUtil.getPositiveInt();
    String key = "k" + this.diff;
    String value = "val" + this.diff;
    LoggingEvent event;

    @Before
    public void setUp() {
        this.discriminator.setContext((Context)this.context);
        this.discriminator.setKey(this.key);
        this.discriminator.setDefaultValue(DEFAULT_VAL);
        this.discriminator.start();
        Assert.assertTrue((boolean)this.discriminator.isStarted());
    }

    @After
    public void teaDown() {
        MDC.clear();
    }

    @Test
    public void smoke() {
        MDC.put((String)this.key, (String)this.value);
        this.event = new LoggingEvent("a", this.logger, Level.DEBUG, "", null, null);
        String discriminatorValue = this.discriminator.getDiscriminatingValue((ILoggingEvent)this.event);
        Assert.assertEquals((Object)this.value, (Object)discriminatorValue);
    }

    @Test
    public void nullMDC() {
        this.event = new LoggingEvent("a", this.logger, Level.DEBUG, "", null, null);
        Assert.assertNull((Object)this.event.getMdc());
        String discriminatorValue = this.discriminator.getDiscriminatingValue((ILoggingEvent)this.event);
        Assert.assertEquals((Object)DEFAULT_VAL, (Object)discriminatorValue);
    }
}

