/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferConfigurator;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.contention.MultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;

public class ReconfigureOnChangeTest {
    static final int THREAD_COUNT = 5;
    static final int LOOP_LEN = 1000000;
    static final String SCAN1_FILE_AS_STR = "src/test/input/turbo/scan 1.xml";
    static final String G_SCAN1_FILE_AS_STR = "src/test/input/turbo/scan 1.groovy";
    static final String SCAN_LBCLASSIC_154_FILE_AS_STR = "src/test/input/turbo/scan_lbclassic154.xml";
    static final String INCLUSION_SCAN_TOPLEVEL0_AS_STR = "src/test/input/turbo/inclusion/topLevel0.xml";
    static final String INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR = "src/test/input/turbo/inclusion/topByResource.xml";
    static final String INCLUSION_SCAN_INNER0_AS_STR = "src/test/input/turbo/inclusion/inner0.xml";
    static final String INCLUSION_SCAN_INNER1_AS_STR = "target/test-classes/asResource/inner1.xml";
    static final int DEFAULT_SLEEP_BETWEEN_UPDATES = 210;
    int sleepBetweenUpdates = 210;
    static int totalTestDuration;
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    MultiThreadedHarness harness;

    @Before
    public void setUp() {
        System.out.println("======== TEST START, time" + System.currentTimeMillis());
        if (Env.isLinux() || Env.isMac()) {
            this.sleepBetweenUpdates = 950;
            totalTestDuration = this.sleepBetweenUpdates * 5;
        } else {
            totalTestDuration = this.sleepBetweenUpdates * 10;
        }
        this.harness = new MultiThreadedHarness((long)totalTestDuration);
    }

    @After
    public void tearDown() {
        System.out.println("======= TEST STOP");
    }

    void configure(File file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    void gConfigure(File file) throws JoranException {
        GafferConfigurator gc = new GafferConfigurator(this.loggerContext);
        gc.run(file);
    }

    RunnableWithCounterAndDone[] buildRunnableArray(File configFile) {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[5];
        rArray[0] = new Updater(configFile);
        for (int i = 1; i < 5; ++i) {
            rArray[i] = new LoggingRunnable(this.logger);
        }
        return rArray;
    }

    void doScanTest(File topLevelFile, File fileToTouch) throws JoranException, IOException, InterruptedException {
        this.configure(topLevelFile);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(fileToTouch);
        this.harness.execute(runnableArray);
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("end of execution ", (Object)this));
        long expectedReconfigurations = runnableArray[0].getCounter();
        this.verify(expectedReconfigurations);
    }

    @Test(timeout=20000L)
    public void randomTest() throws JoranException, IOException, InterruptedException {
        Random rand = new Random(System.currentTimeMillis());
        switch (rand.nextInt(5)) {
            case 0: {
                this.scan1();
                break;
            }
            case 1: {
                this.scanWithFileInclusion();
                break;
            }
            case 2: {
                this.scanWithResourceInclusion();
                break;
            }
            case 3: {
                this.scan_lbclassic154();
                break;
            }
            case 4: {
                this.gscan1();
            }
        }
    }

    public void scan1() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN1_FILE_AS_STR);
        this.doScanTest(file, file);
    }

    public void scanWithFileInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOPLEVEL0_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER0_AS_STR);
        this.doScanTest(topLevelFile, innerFile);
    }

    public void scanWithResourceInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER1_AS_STR);
        this.doScanTest(topLevelFile, innerFile);
    }

    public void gscan1() throws JoranException, IOException, InterruptedException {
        File file = new File(G_SCAN1_FILE_AS_STR);
        this.gConfigure(file);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(file);
        this.harness.execute(runnableArray);
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("end of execution ", (Object)this));
        long expectedRreconfigurations = runnableArray[0].getCounter();
        this.verify(expectedRreconfigurations);
    }

    public void scan_lbclassic154() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN_LBCLASSIC_154_FILE_AS_STR);
        this.configure(file);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(file);
        this.harness.execute(runnableArray);
        this.loggerContext.getStatusManager().add((Status)new InfoStatus("end of execution ", (Object)this));
        long expectedReconfigurations = runnableArray[0].getCounter();
        this.verify(expectedReconfigurations);
    }

    void verify(long expectedReconfigurations) {
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        StatusPrinter.print((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.isErrorFree());
        int effectiveResets = checker.matchCount("Resetting and reconfiguring context");
        Assert.assertTrue(((long)effectiveResets <= expectedReconfigurations ? 1 : 0) != 0);
        String failMsg = "effective=" + effectiveResets + ", expected=" + expectedReconfigurations;
        if (Env.isJDK6OrHigher()) {
            Assert.assertTrue((String)failMsg, ((double)effectiveResets * 1.5 >= (double)expectedReconfigurations * 1.0 ? 1 : 0) != 0);
        }
    }

    ReconfigureOnChangeFilter initROCF() throws MalformedURLException {
        ReconfigureOnChangeFilter rocf = new ReconfigureOnChangeFilter();
        rocf.setContext((Context)this.loggerContext);
        File file = new File(SCAN1_FILE_AS_STR);
        ConfigurationWatchListUtil.setMainWatchURL((Context)this.loggerContext, (URL)file.toURI().toURL());
        rocf.start();
        return rocf;
    }

    @Test
    public void directPerfTest() throws MalformedURLException {
        if (Env.isLinux()) {
            return;
        }
        ReconfigureOnChangeFilter rocf = this.initROCF();
        Assert.assertTrue((boolean)rocf.isStarted());
        for (int i = 0; i < 30; ++i) {
            this.directLoop(rocf);
        }
        double avg = this.directLoop(rocf);
        System.out.println("directPerfTest: " + avg);
        long referencePerf = 18L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    public double directLoop(ReconfigureOnChangeFilter rocf) {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            rocf.decide(null, this.logger, Level.DEBUG, " ", null, null);
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    @Test
    public void indirectPerfTest() throws MalformedURLException {
        if (Env.isLinux()) {
            return;
        }
        ReconfigureOnChangeFilter rocf = this.initROCF();
        Assert.assertTrue((boolean)rocf.isStarted());
        this.loggerContext.addTurboFilter((TurboFilter)rocf);
        this.logger.setLevel(Level.ERROR);
        this.indirectLoop();
        double avg = this.indirectLoop();
        System.out.println(avg);
        long referencePerf = 68L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    void addInfo(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new InfoStatus(msg, o));
    }

    public double indirectLoop() {
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            this.logger.debug("hello");
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    class Updater
    extends RunnableWithCounterAndDone {
        File configFile;

        Updater(File configFile) {
            this.configFile = configFile;
        }

        public void run() {
            while (!this.isDone()) {
                try {
                    Thread.sleep(ReconfigureOnChangeTest.this.sleepBetweenUpdates);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isDone()) {
                    return;
                }
                ++this.counter;
                ReconfigureOnChangeTest.this.addInfo("***settting last modified", (Object)this);
                this.configFile.setLastModified(System.currentTimeMillis());
            }
        }
    }
}

