/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.LoggerTestHelper;
import ch.qos.logback.core.status.StatusManager;
import junit.framework.TestCase;

public class LoggerContextTest
extends TestCase {
    LoggerContext lc;

    protected void setUp() throws Exception {
        Logger.instanceCount = 0;
        this.lc = new LoggerContext();
        this.lc.setName("x");
    }

    public void testRootGetLogger() {
        Logger root = this.lc.getLogger("root");
        LoggerContextTest.assertEquals((Object)Level.DEBUG, (Object)root.getLevel());
        LoggerContextTest.assertEquals((Object)Level.DEBUG, (Object)root.getEffectiveLevel());
    }

    public void testLoggerX() {
        Logger x = this.lc.getLogger("x");
        LoggerContextTest.assertNotNull((Object)x);
        LoggerContextTest.assertEquals((String)"x", (String)x.getName());
        LoggerContextTest.assertNull((Object)x.getLevel());
        LoggerContextTest.assertEquals((Object)Level.DEBUG, (Object)x.getEffectiveLevel());
    }

    public void testEmpty() {
        Logger empty = this.lc.getLogger("");
        LoggerTestHelper.assertNameEquals(empty, "");
        LoggerTestHelper.assertLevels(null, empty, Level.DEBUG);
        Logger dot = this.lc.getLogger(".");
        LoggerTestHelper.assertNameEquals(dot, ".");
        LoggerTestHelper.assertLevels(null, dot, Level.DEBUG);
        LoggerContextTest.assertEquals((int)3, (int)Logger.instanceCount);
    }

    public void testDotDot() {
        Logger dotdot = this.lc.getLogger("..");
        LoggerContextTest.assertEquals((int)4, (int)Logger.instanceCount);
        LoggerTestHelper.assertNameEquals(dotdot, "..");
    }

    public void testLoggerXY() {
        LoggerContextTest.assertEquals((int)1, (int)Logger.instanceCount);
        Logger xy = this.lc.getLogger("x.y");
        LoggerContextTest.assertEquals((int)3, (int)Logger.instanceCount);
        LoggerTestHelper.assertNameEquals(xy, "x.y");
        LoggerTestHelper.assertLevels(null, xy, Level.DEBUG);
        Logger x = this.lc.getLogger("x");
        LoggerContextTest.assertEquals((int)3, (int)Logger.instanceCount);
        Logger xy2 = this.lc.getLogger("x.y");
        LoggerContextTest.assertEquals((Object)xy, (Object)xy2);
        Logger x2 = this.lc.getLogger("x");
        LoggerContextTest.assertEquals((Object)x, (Object)x2);
        LoggerContextTest.assertEquals((int)3, (int)Logger.instanceCount);
    }

    public void testLoggerMultipleChildren() {
        LoggerContextTest.assertEquals((int)1, (int)Logger.instanceCount);
        Logger xy0 = this.lc.getLogger("x.y0");
        LoggerTestHelper.assertNameEquals(xy0, "x.y0");
        Logger xy1 = this.lc.getLogger("x.y1");
        LoggerTestHelper.assertNameEquals(xy1, "x.y1");
        LoggerTestHelper.assertLevels(null, xy0, Level.DEBUG);
        LoggerTestHelper.assertLevels(null, xy1, Level.DEBUG);
        LoggerContextTest.assertEquals((int)4, (int)Logger.instanceCount);
        for (int i = 0; i < 100; ++i) {
            Logger xy_i = this.lc.getLogger("x.y" + i);
            LoggerTestHelper.assertNameEquals(xy_i, "x.y" + i);
            LoggerTestHelper.assertLevels(null, xy_i, Level.DEBUG);
        }
        LoggerContextTest.assertEquals((int)102, (int)Logger.instanceCount);
    }

    public void testMultiLevel() {
        Logger wxyz = this.lc.getLogger("w.x.y.z");
        LoggerTestHelper.assertNameEquals(wxyz, "w.x.y.z");
        LoggerTestHelper.assertLevels(null, wxyz, Level.DEBUG);
        Logger wx = this.lc.getLogger("w.x");
        wx.setLevel(Level.INFO);
        LoggerTestHelper.assertNameEquals(wx, "w.x");
        LoggerTestHelper.assertLevels(Level.INFO, wx, Level.INFO);
        LoggerTestHelper.assertLevels(null, this.lc.getLogger("w.x.y"), Level.INFO);
        LoggerTestHelper.assertLevels(null, wxyz, Level.INFO);
    }

    public void testStatusWithUnconfiguredContext() {
        int i;
        Logger logger = this.lc.getLogger(LoggerContextTest.class);
        for (i = 0; i < 3; ++i) {
            logger.debug("test");
        }
        logger = this.lc.getLogger("x.y.z");
        for (i = 0; i < 3; ++i) {
            logger.debug("test");
        }
        StatusManager sm = this.lc.getStatusManager();
        LoggerContextTest.assertTrue((String)"StatusManager has recieved too many messages", (sm.getCount() == 1 ? 1 : 0) != 0);
    }
}

