/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.mock;

import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.BufferedInputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockSocketServer
extends Thread {
    static final int PORT = 4560;
    final int loopLen;
    List<LoggingEvent> loggingEventList = new ArrayList<LoggingEvent>();
    boolean finished = false;

    public MockSocketServer(int loopLen) {
        this.loopLen = loopLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ObjectInputStream ois = null;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(4560);
            Socket socket = serverSocket.accept();
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            for (int i = 0; i < this.loopLen; ++i) {
                LoggingEvent event = (LoggingEvent)ois.readObject();
                this.loggingEventList.add(event);
            }
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception e) {}
            }
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public List<LoggingEvent> getEventsList() {
        return this.loggingEventList;
    }
}

