/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import junit.framework.TestCase;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MarkerConverterTest
extends TestCase {
    LoggerContext lc;
    Marker marker;
    MarkerConverter converter;

    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MarkerConverter();
        this.converter.start();
    }

    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    public void testWithNullMarker() {
        this.marker = null;
        String result = this.converter.convert(this.createLoggingEvent());
        MarkerConverterTest.assertEquals((String)"", (String)result);
    }

    public void testWithMarker() {
        String name = "test";
        this.marker = MarkerFactory.getMarker((String)name);
        String result = this.converter.convert(this.createLoggingEvent());
        MarkerConverterTest.assertEquals((String)name, (String)result);
    }

    public void testWithOneChildMarker() {
        this.marker = MarkerFactory.getMarker((String)"test");
        this.marker.add(MarkerFactory.getMarker((String)"child"));
        String result = this.converter.convert(this.createLoggingEvent());
        MarkerConverterTest.assertEquals((String)"test [ child ]", (String)result);
    }

    public void testWithSeveralChildMarker() {
        this.marker = MarkerFactory.getMarker((String)"testParent");
        this.marker.add(MarkerFactory.getMarker((String)"child1"));
        this.marker.add(MarkerFactory.getMarker((String)"child2"));
        this.marker.add(MarkerFactory.getMarker((String)"child3"));
        String result = this.converter.convert(this.createLoggingEvent());
        MarkerConverterTest.assertEquals((String)"testParent [ child1, child2, child3 ]", (String)result);
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.lc.getLogger("root"), Level.DEBUG, "test message", null, null);
        le.setMarker(this.marker);
        return le;
    }
}

