/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.TestCase;
import org.slf4j.LoggerFactory;

public class BasicLoggerTest
extends TestCase {
    public void testBasic() {
        LoggerContext lc = new LoggerContext();
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        Logger root = lc.getLogger("root");
        root.addAppender((Appender)listAppender);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertEquals((int)0, (int)listAppender.list.size());
        logger.debug("hello");
        BasicLoggerTest.assertEquals((int)1, (int)listAppender.list.size());
    }

    public void testNoStart() {
        LoggerContext lc = new LoggerContext();
        ListAppender listAppender = new ListAppender();
        listAppender.setContext((Context)lc);
        Logger root = lc.getLogger("root");
        root.addAppender((Appender)listAppender);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        logger.debug("hello");
        StatusPrinter.print((StatusManager)lc.getStatusManager());
    }

    public void testAdditive() {
        LoggerContext lc = new LoggerContext();
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        Logger root = lc.getLogger("root");
        root.addAppender((Appender)listAppender);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        logger.addAppender((Appender)listAppender);
        logger.setAdditive(false);
        logger.debug("hello");
        BasicLoggerTest.assertEquals((int)1, (int)listAppender.list.size());
    }

    public void testRootLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"root");
        LoggerContext lc = logger.getLoggerContext();
        BasicLoggerTest.assertNotNull((String)"Returned logger is null", (Object)logger);
        BasicLoggerTest.assertEquals((String)"Return logger isn't named root", (String)logger.getName(), (String)"root");
        BasicLoggerTest.assertTrue((String)"logger instances should be indentical", (logger == lc.root ? 1 : 0) != 0);
    }

    public void testBasicFiltering() throws Exception {
        LoggerContext lc = new LoggerContext();
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        Logger root = lc.getLogger("root");
        root.addAppender((Appender)listAppender);
        root.setLevel(Level.INFO);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        logger.debug("x");
        BasicLoggerTest.assertEquals((int)0, (int)listAppender.list.size());
        logger.info("x");
        logger.warn("x");
        logger.error("x");
        BasicLoggerTest.assertEquals((int)3, (int)listAppender.list.size());
    }

    public void testEnabledX_All() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.ALL);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertTrue((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
    }

    public void testEnabledX_Debug() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.DEBUG);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertTrue((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
    }

    public void testEnabledX_Info() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.INFO);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertFalse((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
    }

    public void testEnabledX_Warn() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.WARN);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertFalse((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
    }

    public void testEnabledX_Errror() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.ERROR);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertFalse((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertTrue((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
    }

    public void testEnabledX_Off() throws Exception {
        LoggerContext lc = new LoggerContext();
        Logger root = lc.getLogger("root");
        root.setLevel(Level.OFF);
        Logger logger = lc.getLogger(BasicLoggerTest.class);
        BasicLoggerTest.assertFalse((boolean)logger.isDebugEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isInfoEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isWarnEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isErrorEnabled());
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.INFO));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.WARN));
        BasicLoggerTest.assertFalse((boolean)logger.isEnabledFor(Level.ERROR));
    }
}

