/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;
import org.hsqldb.Server;
import org.hsqldb.jdbcDriver;

public abstract class DBAppenderTestBase
extends TestCase {
    public static final String HSQLDB_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    String url = null;
    String user = "sa";
    String password = "";
    Server server;
    HsqlMode mode = HsqlMode.MEM;

    public DBAppenderTestBase(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        switch (this.mode) {
            case NET: {
                this.url = "jdbc:hsqldb:hsql://localhost:4808/test";
                break;
            }
            case MEM: {
                this.url = "jdbc:hsqldb:mem:test;sql.enforce_strict_size=true";
                this.server = new Server();
                this.server.setDatabaseName(0, "test");
                this.server.setDatabasePath(0, this.url);
                this.server.setLogWriter(new PrintWriter(System.out));
                this.server.setErrWriter(new PrintWriter(System.out));
                this.server.setTrace(false);
                this.server.setSilent(false);
                this.server.start();
                break;
            }
            case FILE: {
                this.url = "jdbc:hsqldb:file:test;sql.enforce_strict_size=true";
            }
        }
        System.out.println(this.server.getState());
        int waitCount = 0;
        while (this.server.getState() != 1 && waitCount < 5) {
            try {
                ++waitCount;
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.createTables();
    }

    public void tearDown() throws SQLException {
        this.dropTables();
        if (this.mode == HsqlMode.MEM) {
            this.server.stop();
            this.server = null;
        }
    }

    Connection newConnection() throws SQLException {
        jdbcDriver driver = new jdbcDriver();
        Properties props = new Properties();
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        return driver.connect(this.url, props);
    }

    void createTables() throws SQLException {
        Connection conn = this.newConnection();
        DBAppenderTestBase.assertNotNull((Object)conn);
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE logging_event (");
        buf.append("timestmp BIGINT NOT NULL,");
        buf.append("formatted_message LONGVARCHAR NOT NULL,");
        buf.append("logger_name VARCHAR(256) NOT NULL,");
        buf.append("level_string VARCHAR(256) NOT NULL,");
        buf.append("thread_name VARCHAR(256),");
        buf.append("reference_flag SMALLINT,");
        buf.append("caller_filename VARCHAR(256), ");
        buf.append("caller_class VARCHAR(256), ");
        buf.append("caller_method VARCHAR(256), ");
        buf.append("caller_line CHAR(4), ");
        buf.append("event_id INT NOT NULL IDENTITY);");
        this.query(conn, buf.toString());
        buf = new StringBuffer();
        buf.append("CREATE TABLE logging_event_property (");
        buf.append("event_id INT NOT NULL,");
        buf.append("mapped_key  VARCHAR(254) NOT NULL,");
        buf.append("mapped_value LONGVARCHAR,");
        buf.append("PRIMARY KEY(event_id, mapped_key),");
        buf.append("FOREIGN KEY (event_id) REFERENCES logging_event(event_id));");
        this.query(conn, buf.toString());
        buf = new StringBuffer();
        buf.append("CREATE TABLE logging_event_exception (");
        buf.append("event_id INT NOT NULL,");
        buf.append("i SMALLINT NOT NULL,");
        buf.append("trace_line VARCHAR(256) NOT NULL,");
        buf.append("PRIMARY KEY(event_id, i),");
        buf.append("FOREIGN KEY (event_id) REFERENCES logging_event(event_id));");
        this.query(conn, buf.toString());
    }

    void dropTables() throws SQLException {
        Connection conn = this.newConnection();
        StringBuffer buf = new StringBuffer();
        buf.append("DROP TABLE logging_event_exception IF EXISTS;");
        this.query(conn, buf.toString());
        buf = new StringBuffer();
        buf.append("DROP TABLE logging_event_property IF EXISTS;");
        this.query(conn, buf.toString());
        buf = new StringBuffer();
        buf.append("DROP TABLE logging_event IF EXISTS;");
        this.query(conn, buf.toString());
    }

    void query(Connection conn, String expression) throws SQLException {
        Statement st = null;
        st = conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
        st.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HsqlMode {
        MEM,
        FILE,
        NET;

    }
}

