/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassNameAbbreviator;
import junit.framework.TestCase;

public class ClassNameAbbreviatorTest
extends TestCase {
    public ClassNameAbbreviatorTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testShortName() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(100);
        String name = "hello";
        ClassNameAbbreviatorTest.assertEquals((String)name, (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(100);
        name = "hello.world";
        ClassNameAbbreviatorTest.assertEquals((String)name, (String)abbreviator.abbreviate(name));
    }

    public void testNoDot() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(1);
        String name = "hello";
        ClassNameAbbreviatorTest.assertEquals((String)name, (String)abbreviator.abbreviate(name));
    }

    public void testOneDot() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(1);
        String name = "hello.world";
        ClassNameAbbreviatorTest.assertEquals((String)"h.world", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = "h.world";
        ClassNameAbbreviatorTest.assertEquals((String)"h.world", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = ".world";
        ClassNameAbbreviatorTest.assertEquals((String)".world", (String)abbreviator.abbreviate(name));
    }

    public void testTwoDot() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(1);
        String name = "com.logback.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = "c.logback.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = "c..Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c..Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = "..Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"..Foobar", (String)abbreviator.abbreviate(name));
    }

    public void test3Dot() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(1);
        String name = "com.logback.xyz.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.x.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(13);
        name = "com.logback.xyz.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.x.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(14);
        name = "com.logback.xyz.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.xyz.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(15);
        name = "com.logback.alligator.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.a.Foobar", (String)abbreviator.abbreviate(name));
    }

    public void testXDot() {
        ClassNameAbbreviator abbreviator = new ClassNameAbbreviator(21);
        String name = "com.logback.wombat.alligator.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.w.a.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(22);
        name = "com.logback.wombat.alligator.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.w.alligator.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(1);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.w.a.t.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(21);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.w.a.tomato.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new ClassNameAbbreviator(29);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        ClassNameAbbreviatorTest.assertEquals((String)"c.l.w.alligator.tomato.Foobar", (String)abbreviator.abbreviate(name));
    }
}

