/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import junit.framework.TestCase;
import org.slf4j.MDC;

public class MDCConverterTest
extends TestCase {
    LoggerContext lc;
    MDCConverter converter;

    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MDCConverter();
        this.converter.start();
    }

    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    public void testConverWithOneEntry() {
        MDC.clear();
        MDC.put((String)"testKey", (String)"testValue");
        LoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        MDCConverterTest.assertEquals((String)"testKey=testValue", (String)result);
    }

    public void testConverWithMultipleEntries() {
        MDC.clear();
        MDC.put((String)"testKey", (String)"testValue");
        MDC.put((String)"testKey2", (String)"testValue2");
        LoggingEvent le = this.createLoggingEvent();
        String result = this.converter.convert(le);
        MDCConverterTest.assertEquals((String)"testKey=testValue, testKey2=testValue2", (String)result);
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.lc.getLogger("root"), Level.DEBUG, "test message", null, null);
        return le;
    }
}

