/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.StringListAppender;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.turbo.DebugUsersTurboFilter;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JoranConfiguratorTest
extends TestCase {
    public JoranConfiguratorTest(String name) {
        super(name);
    }

    public void testSimpleList() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleList.xml");
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        JoranConfiguratorTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        JoranConfiguratorTest.assertEquals((int)1, (int)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        JoranConfiguratorTest.assertEquals((String)msg, (String)le.getMessage());
    }

    public void testLevel() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleLevel.xml");
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        JoranConfiguratorTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        JoranConfiguratorTest.assertEquals((int)0, (int)listAppender.list.size());
    }

    public void testEval() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/callerData.xml");
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        String msg = "hello world";
        logger.debug("toto");
        logger.debug(msg);
        StringListAppender slAppender = (StringListAppender)loggerContext.getLogger("root").getAppender("STR_LIST");
        JoranConfiguratorTest.assertNotNull((Object)((Object)slAppender));
        JoranConfiguratorTest.assertEquals((int)2, (int)slAppender.strList.size());
        JoranConfiguratorTest.assertTrue((boolean)slAppender.strList.get(0).contains(" DEBUG - toto"));
        String str1 = slAppender.strList.get(1);
        JoranConfiguratorTest.assertTrue((boolean)str1.contains("Caller+0"));
        JoranConfiguratorTest.assertTrue((boolean)str1.contains(" DEBUG - hello world"));
    }

    public void testTurboFilter() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/turbo.xml");
        TurboFilter filter = loggerContext.getFirstTurboFilter();
        JoranConfiguratorTest.assertTrue((boolean)(filter instanceof NOPTurboFilter));
    }

    public void testTurboFilterWithStringList() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/turbo2.xml");
        TurboFilter filter = loggerContext.getFirstTurboFilter();
        JoranConfiguratorTest.assertTrue((boolean)(filter instanceof DebugUsersTurboFilter));
        DebugUsersTurboFilter dutf = (DebugUsersTurboFilter)filter;
        JoranConfiguratorTest.assertEquals((int)2, (int)dutf.getUsers().size());
    }

    public void testLevelFilter() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/levelFilter.xml");
        StatusPrinter.print((Context)loggerContext);
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        logger.warn("hello");
        logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)loggerContext.getLogger("root").getAppender("LIST");
        JoranConfiguratorTest.assertNotNull((Object)listAppender);
        JoranConfiguratorTest.assertEquals((int)1, (int)listAppender.list.size());
        LoggingEvent back = (LoggingEvent)listAppender.list.get(0);
        JoranConfiguratorTest.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        JoranConfiguratorTest.assertEquals((String)"hello", (String)back.getMessage());
    }

    public void testEvaluatorFilter() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/evaluatorFilter.xml");
        StatusPrinter.print((Context)loggerContext);
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        logger.warn("hello");
        logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)loggerContext.getLogger("root").getAppender("LIST");
        JoranConfiguratorTest.assertNotNull((Object)listAppender);
        JoranConfiguratorTest.assertEquals((int)1, (int)listAppender.list.size());
        LoggingEvent back = (LoggingEvent)listAppender.list.get(0);
        JoranConfiguratorTest.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        JoranConfiguratorTest.assertEquals((String)"hello", (String)back.getMessage());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(JoranConfiguratorTest.class);
        return suite;
    }
}

