/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.StringListAppender;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.turbo.DebugUsersTurboFilter;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BasicJoranTest
extends TestCase {
    public BasicJoranTest(String name) {
        super(name);
    }

    public void testSimpleList() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleList.xml");
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        BasicJoranTest.assertEquals((int)1, (int)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        BasicJoranTest.assertEquals((String)msg, (String)le.getMessage());
    }

    public void testLevel() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleLevel.xml");
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
    }

    public void testEval() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/callerData.xml");
        StatusPrinter.print((Context)loggerContext);
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        String msg = "hello world";
        logger.debug("toto");
        logger.debug(msg);
        StringListAppender slAppender = (StringListAppender)loggerContext.getLogger("root").getAppender("STR_LIST");
        BasicJoranTest.assertNotNull((Object)((Object)slAppender));
        BasicJoranTest.assertEquals((int)2, (int)slAppender.strList.size());
        BasicJoranTest.assertTrue((boolean)slAppender.strList.get(0).contains(" DEBUG - toto"));
        String str1 = slAppender.strList.get(1);
        BasicJoranTest.assertTrue((boolean)str1.contains("Caller+0"));
        BasicJoranTest.assertTrue((boolean)str1.contains(" DEBUG - hello world"));
    }

    public void testTurboFilter() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/turbo.xml");
        TurboFilter filter = loggerContext.getFirstTurboFilter();
        BasicJoranTest.assertTrue((boolean)(filter instanceof NOPTurboFilter));
    }

    public void testTurboFilterWithStringList() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/turbo2.xml");
        TurboFilter filter = loggerContext.getFirstTurboFilter();
        BasicJoranTest.assertTrue((boolean)(filter instanceof DebugUsersTurboFilter));
        DebugUsersTurboFilter dutf = (DebugUsersTurboFilter)filter;
        BasicJoranTest.assertEquals((int)2, (int)dutf.getUsers().size());
    }

    public static Test COMMENTED_OUT_suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new BasicJoranTest("testLevel"));
        return suite;
    }
}

