/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.ClassicGlobal;
import ch.qos.logback.classic.net.mock.MockInitialContext;
import ch.qos.logback.classic.net.mock.MockInitialContextFactory;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.servlet.ContextDetachingSCL;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextDetachingSCLTest
extends TestCase {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";
    ContextDetachingSCL listener;

    protected void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        LoggerFactory.setup();
        this.listener = new ContextDetachingSCL();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        Logger logger = LoggerFactory.getLogger(ContextDetachingSCLTest.class);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
        super.tearDown();
    }

    public void testDetach() {
        ContextJNDISelector selector = (ContextJNDISelector)LoggerFactory.getContextSelector();
        this.listener.contextDestroyed(null);
        ContextDetachingSCLTest.assertEquals((int)0, (int)selector.getCount());
    }

    public void testDetachWithMissingContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(ClassicGlobal.JNDI_CONTEXT_NAME, "tata");
        ContextJNDISelector selector = (ContextJNDISelector)LoggerFactory.getContextSelector();
        this.listener.contextDestroyed(null);
        ContextDetachingSCLTest.assertEquals((int)1, (int)selector.getCount());
    }
}

