/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.selector.DefaultContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.util.OptionHelper;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.Util;

public final class LoggerFactory {
    static LoggerContext defaultLoggerContext;
    private static ContextSelector contextSelector;

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        return contextSelector.getLoggerContext().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return contextSelector.getLoggerContext().getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        return contextSelector.getLoggerContext();
    }

    public static ContextSelector getContextSelector() {
        return contextSelector;
    }

    public static void setup() {
        try {
            defaultLoggerContext = new LoggerContext();
            defaultLoggerContext.setName("default");
            ContextInitializer.autoConfig(defaultLoggerContext);
            String contextSelectorStr = OptionHelper.getSystemProperty((String)"logback.ContextSelector", null);
            if (contextSelectorStr == null) {
                contextSelector = new DefaultContextSelector(defaultLoggerContext);
            } else if (contextSelectorStr.equals("JNDI")) {
                contextSelector = new ContextJNDISelector(defaultLoggerContext);
            }
        }
        catch (Exception e) {
            Util.reportFailure((String)("Failed to instantiate logger [" + LoggerContext.class + "]"), (Throwable)e);
        }
    }

    static {
        LoggerFactory.setup();
    }
}

