/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateFormatOriginal_tzest
extends TestCase {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    static final long NANOS_IN_ONE_SEC = 1000000000L;

    public DateFormatOriginal_tzest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(DateFormatOriginal_tzest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DateFormatOriginal_tzest.suite());
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRaw() throws Exception {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(ISO8601_PATTERN);
        DateTimeFormatter jodaFormat = DateTimeFormat.forPattern((String)ISO8601_PATTERN);
        Date date = new Date();
        DateTime dateTime = new DateTime((Object)date);
        long start = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            jodaFormat.print((ReadableInstant)dateTime);
        }
        long jodaAvg = (System.nanoTime() - start) / 100000L;
        start = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            simpleFormat.format(date);
        }
        long simpleAvg = (System.nanoTime() - start) / 100000L;
        float diff = (float)(simpleAvg - jodaAvg) / (float)simpleAvg * 100.0f;
        System.out.println("Raw - JDK: " + simpleAvg + " ns Joda: " + jodaAvg + " ns - Difference: " + diff + "%");
    }

    public void testSynchronized() throws Exception {
        SynchronizedDateFormatter formatter = new SynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Synchronized DateFormat: %,.4f seconds\n", actual);
    }

    public void testUnSynchronized() throws Exception {
        UnsynchronizedDateFormatter formatter = new UnsynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Unsynchronized DateFormat: %,.4f seconds\n", actual);
    }

    public void testThreadLocal() throws Exception {
        ThreadLocalDateFormatter formatter = new ThreadLocalDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("ThreadLocal DateFormat: %,.4f seconds\n", actual);
    }

    public void testDateTimeFormatter() throws Exception {
        int threads = 10;
        int iterations = 10000;
        DateTimeFormatThread[] formatThreads = new DateTimeFormatThread[threads];
        JodaFormatter formatter = new JodaFormatter();
        Date date = new Date();
        DateTime dateTime = new DateTime((Object)date);
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateTimeFormatThread(formatter, dateTime, iterations);
        }
        long start = System.nanoTime();
        for (DateTimeFormatThread thread : formatThreads) {
            thread.start();
        }
        for (DateTimeFormatThread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Joda DateTimeFormatter: %,.4f seconds\n", actual);
    }

    public static class DateTimeFormatThread
    extends Thread {
        JodaFormatter formatter;
        DateTime date;
        long iterCount;

        public DateTimeFormatThread(JodaFormatter f, DateTime date, long iterations) {
            this.formatter = f;
            this.date = date;
            this.iterCount = iterations;
        }

        public void run() {
            int i = 0;
            while ((long)i < this.iterCount) {
                this.formatter.format(this.date);
                ++i;
            }
        }
    }

    public static class DateFormatThread
    extends Thread {
        Formatter formatter;
        Date date;
        long iterCount;

        public DateFormatThread(Formatter f, Date date, long iterations) {
            this.formatter = f;
            this.date = date;
            this.iterCount = iterations;
        }

        public void run() {
            int i = 0;
            while ((long)i < this.iterCount) {
                this.formatter.format(this.date);
                ++i;
            }
        }
    }

    public static class JodaFormatter {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSS");

        public String format(DateTime date) {
            return this.formatter.print((ReadableInstant)date);
        }
    }

    public static class ThreadLocalDateFormatter
    implements Formatter {
        ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected synchronized SimpleDateFormat initialValue() {
                return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN);
            }
        };

        public String format(Date date) {
            return this.formatter.get().format(date);
        }
    }

    public static class UnsynchronizedDateFormatter
    implements Formatter {
        public synchronized String format(Date date) {
            return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN).format(date);
        }
    }

    public static class SynchronizedDateFormatter
    implements Formatter {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

        public synchronized String format(Date date) {
            return this.simpleFormat.format(date);
        }
    }

    public static interface Formatter {
        public String format(Date var1);
    }
}

