/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.BogusClassLoader;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.util.TeztHelper;
import ch.qos.logback.core.util.SystemInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class PackagingDataCalculatorTest {
    public void verify(ThrowableProxy tp) {
        for (StackTraceElementProxy step : tp.getStackTraceElementProxyArray()) {
            if (step == null) continue;
            Assert.assertNotNull((Object)step.getClassPackagingData());
        }
    }

    @Test
    public void smoke() throws Exception {
        Throwable t = new Throwable("x");
        ThrowableProxy tp = new ThrowableProxy(t);
        PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
        pdc.calculate((IThrowableProxy)tp);
        this.verify(tp);
        tp.fullDump();
    }

    @Test
    public void nested() throws Exception {
        Throwable t = TeztHelper.makeNestedException(3);
        ThrowableProxy tp = new ThrowableProxy(t);
        PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
        pdc.calculate((IThrowableProxy)tp);
        this.verify(tp);
    }

    public void doCalculateClassPackagingData(boolean withClassPackagingCalculation) {
        try {
            throw new Exception("testing");
        }
        catch (Throwable e) {
            ThrowableProxy tp = new ThrowableProxy(e);
            if (withClassPackagingCalculation) {
                PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
                pdc.calculate((IThrowableProxy)tp);
            }
            return;
        }
    }

    double loop(int len, boolean withClassPackagingCalculation) {
        long start = System.nanoTime();
        for (int i = 0; i < len; ++i) {
            this.doCalculateClassPackagingData(withClassPackagingCalculation);
        }
        return (1.0 * (double)System.nanoTime() - (double)start) / (double)len / 1000.0;
    }

    @Test
    public void perfTest() {
        int len = 1000;
        this.loop(len, false);
        this.loop(len, true);
        double d0 = this.loop(len, false);
        System.out.println("without packaging info " + d0 + " microseconds");
        double d1 = this.loop(len, true);
        System.out.println("with    packaging info " + d1 + " microseconds");
        int slackFactor = 8;
        if (!SystemInfo.getJavaVendor().contains("Sun")) {
            slackFactor = 10;
        }
        Assert.assertTrue((String)("computing class packaging data (" + d1 + ") should have been less than " + slackFactor + " times the time it takes to process an exception " + d0 * (double)slackFactor), (d0 * (double)slackFactor > d1 ? 1 : 0) != 0);
    }

    private ClassLoader makeBogusClassLoader() throws MalformedURLException {
        ClassLoader currentClassLoader = this.getClass().getClassLoader();
        BogusClassLoader bcl = new BogusClassLoader(new URL[0], currentClassLoader);
        return bcl;
    }

    @Test
    public void noClassDefFoundError_LBCLASSIC_125Test() throws MalformedURLException {
        URLClassLoader cl = (URLClassLoader)this.makeBogusClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        Throwable t = new Throwable("x");
        ThrowableProxy tp = new ThrowableProxy(t);
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        StackTraceElement bogusSTE = new StackTraceElement("com.Bogus", "myMethod", "myFile", 12);
        stepArray[0] = new StackTraceElementProxy(bogusSTE);
        PackagingDataCalculator pdc = tp.getPackagingDataCalculator();
        pdc.calculate((IThrowableProxy)tp);
    }
}

