/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.TeztHelper;
import ch.qos.logback.core.Context;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrowableProxyConverterTest {
    LoggerContext lc = new LoggerContext();
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
        this.tpc.setContext((Context)this.lc);
        this.tpc.start();
    }

    @After
    public void tearDown() throws Exception {
    }

    private ILoggingEvent createLoggingEvent(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", t, null);
    }

    @Test
    public void smoke() {
        Exception t = new Exception("smoke");
        this.verify(t);
    }

    @Test
    public void nested() {
        Throwable t = TeztHelper.makeNestedException(1);
        this.verify(t);
    }

    void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        String result = this.tpc.convert(le);
        System.out.println(result);
        result = result.replace("common frames omitted", "more");
        Assert.assertEquals((Object)this.sw.toString(), (Object)result);
    }
}

