/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.dom4j.io.SAXReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAppender_GreenTest {
    static boolean SYNCHRONOUS = false;
    static boolean ASYNCHRONOUS = true;
    static int port = RandomUtil.getRandomServerPort();
    static GreenMail greenMailServer;
    SMTPAppender smtpAppender;
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(this.getClass());
    static final String TEST_SUBJECT = "test subject";
    static final String HEADER = "HEADER\n";
    static final String FOOTER = "FOOTER\n";
    static final String DEFAULT_PATTERN = "%-4relative %mdc [%thread] %-5level %class - %msg%n";
    int oldCount;

    @Before
    public void setUp() throws Exception {
        ServerSetup serverSetup = new ServerSetup(port, "localhost", "smtp");
        greenMailServer = new GreenMail(serverSetup);
        greenMailServer.start();
        MDC.clear();
        this.oldCount = this.messageCount();
    }

    @After
    public void tearDown() throws Exception {
        greenMailServer.stop();
    }

    void buildSMTPAppender(boolean synchronicity) throws Exception {
        this.smtpAppender = new SMTPAppender();
        this.smtpAppender.setContext((Context)this.lc);
        this.smtpAppender.setName("smtp");
        this.smtpAppender.setFrom("user@host.dom");
        this.smtpAppender.setSMTPHost("localhost");
        this.smtpAppender.setSMTPPort(port);
        this.smtpAppender.setSubject(TEST_SUBJECT);
        this.smtpAppender.addTo("nospam@qos.ch");
        this.smtpAppender.setAsynchronousSending(synchronicity);
    }

    private Layout<ILoggingEvent> buildPatternLayout(LoggerContext lc, String pattern) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader(HEADER);
        layout.setOutputPatternAsHeader(false);
        layout.setPattern(pattern);
        layout.setFileFooter(FOOTER);
        layout.start();
        return layout;
    }

    private Layout<ILoggingEvent> buildHTMLLayout(LoggerContext lc) {
        HTMLLayout layout = new HTMLLayout();
        layout.setContext((Context)lc);
        layout.setPattern("%level%class%msg");
        layout.start();
        return layout;
    }

    private int messageCount() throws MessagingException, IOException {
        MimeMessage[] mma = greenMailServer.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        return mma.length;
    }

    private MimeMultipart verify(String subject) throws MessagingException, IOException {
        MimeMessage[] mma = greenMailServer.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)(this.oldCount + 1), (long)mma.length);
        MimeMessage mm = mma[this.oldCount];
        Assert.assertEquals((Object)subject, (Object)mm.getSubject());
        return (MimeMultipart)mm.getContent();
    }

    void waitUntilEmailIsSent() throws InterruptedException {
        this.lc.getExecutorService().shutdown();
        this.lc.getExecutorService().awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void syncronousSmoke() throws Exception {
        this.buildSMTPAppender(SYNCHRONOUS);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void asyncronousSmoke() throws Exception {
        this.buildSMTPAppender(ASYNCHRONOUS);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void callerDataShouldBeCorrectlySetWithAsyncronousSending() throws Exception {
        this.buildSMTPAppender(ASYNCHRONOUS);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.setIncludeCallerData(true);
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.contains("DEBUG " + this.getClass().getName() + " - hello"));
    }

    @Test
    public void LBCLASSIC_104() throws Exception {
        this.buildSMTPAppender(SYNCHRONOUS);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        MDC.put((String)"key", (String)"val");
        this.logger.debug("LBCLASSIC_104");
        MDC.clear();
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        System.out.println(body);
        Assert.assertTrue((boolean)body.contains("key=val"));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void html() throws Exception {
        this.buildSMTPAppender(SYNCHRONOUS);
        this.smtpAppender.setAsynchronousSending(false);
        this.smtpAppender.setLayout(this.buildHTMLLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("html");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        reader.read(mp.getBodyPart(0).getInputStream());
    }

    private byte[] getAsByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int n = -1;
        while ((n = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        System.out.println("port=" + port);
        this.lc.putProperty("port", "" + port);
        jc.doConfigure(file);
    }

    @Test
    public void testCustomEvaluator() throws Exception {
        this.configure("src/test/input/joran/smtp/customEvaluator.xml");
        this.logger.debug("hello");
        String msg2 = "world";
        this.logger.debug(msg2);
        this.logger.debug("invisible");
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(this.getClass().getName() + " - " + msg2);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertEquals((Object)"helloworld", (Object)body);
    }

    @Test
    public void testCustomBufferSize() throws Exception {
        this.configure("src/test/input/joran/smtp/customBufferSize.xml");
        this.logger.debug("invisible1");
        this.logger.debug("invisible2");
        String msg = "hello";
        this.logger.error(msg);
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(this.getClass().getName() + " - " + msg);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertEquals((Object)msg, (Object)body);
    }

    @Test
    public void testMultipleTo() throws Exception {
        this.buildSMTPAppender(SYNCHRONOUS);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.addTo("Test <test@example.com>, other-test@example.com");
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        MimeMessage[] mma = greenMailServer.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)(this.oldCount + 3), (long)mma.length);
    }

    @Test
    public void bufferShouldBeResetBetweenMessages() throws Exception {
        this.buildSMTPAppender(SYNCHRONOUS);
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc, DEFAULT_PATTERN));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        String msg0 = "hello zero";
        this.logger.debug(msg0);
        this.logger.error("error zero");
        String msg1 = "hello one";
        this.logger.debug(msg1);
        this.logger.error("error one");
        this.waitUntilEmailIsSent();
        MimeMessage[] mma = greenMailServer.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)(this.oldCount + 2), (long)mma.length);
        MimeMessage mm0 = mma[this.oldCount];
        MimeMultipart content0 = (MimeMultipart)mm0.getContent();
        String body0 = GreenMailUtil.getBody((Part)content0.getBodyPart(0));
        MimeMessage mm1 = mma[this.oldCount + 1];
        MimeMultipart content1 = (MimeMultipart)mm1.getContent();
        String body1 = GreenMailUtil.getBody((Part)content1.getBodyPart(0));
        Assert.assertFalse((boolean)body1.contains(msg0));
    }
}

