/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SocketAppenderTest {
    static final String LIST_APPENDER_NAME = "list";
    static final int RECONNECT_DELAY = 1;
    static final int SERVER_LATCH_WAIT_TIMEOUT = 1000;
    static final int APPENDER_LATCH_WAIT_TIMEOUT = 10;
    static int diff = RandomUtil.getPositiveInt();
    static int PORT = 1024 + diff % 30000;
    static LoggerContext SERVER_LOGGER_CONTEXT = new LoggerContext();
    static ListAppenderWithLatch<ILoggingEvent> LIST_APPENDER = new ListAppenderWithLatch();
    private static SimpleSocketServer SIMPLE_SOCKET_SERVER;
    String mdcKey = "key" + diff;
    LoggerContext loggerContext = new LoggerContext();
    SocketAppender socketAppender = new SocketAppender();
    private boolean includeCallerData = false;

    @BeforeClass
    public static void beforeClass() throws InterruptedException {
        SocketAppenderTest.fireServer();
        SocketAppenderTest.waitForServerToStart();
    }

    @AfterClass
    public static void afterClass() {
        SocketAppenderTest.closeServer();
    }

    private static void closeServer() {
        SIMPLE_SOCKET_SERVER.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        SocketAppenderTest.LIST_APPENDER.list.clear();
    }

    @Test
    public void startFailNoRemoteHost() {
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.loggerContext);
        appender.setPort(PORT);
        appender.start();
        Assert.assertEquals((long)1L, (long)this.loggerContext.getStatusManager().getCount());
    }

    @Test
    public void receiveMessage() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertEquals((Object)"test msg", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    @Test
    public void receiveWithContext() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        String loggerName = remoteEvent.getLoggerName();
        Assert.assertNotNull((Object)loggerName);
        Assert.assertEquals((Object)"ROOT", (Object)loggerName);
        LoggerContextVO loggerContextRemoteView = remoteEvent.getLoggerContextVO();
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"test", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void messageWithMDC() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger root = this.loggerContext.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get(this.mdcKey));
        Assert.assertNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void withCallerData() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.includeCallerData = true;
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertNotNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void messageWithMarker() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        logger.debug(marker, "test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertEquals((Object)"testMarker", (Object)remoteEvent.getMarker().getName());
    }

    @Test
    public void messageWithUpdatedMDC() throws InterruptedException {
        this.updateListAppenderLatch(2);
        this.configureClient();
        Logger root = this.loggerContext.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        MDC.put((String)this.mdcKey, (String)"updatedTestValue");
        root.debug("test msg 2");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)2L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(1);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get(this.mdcKey));
    }

    @Test
    public void lateServerLaunch() throws InterruptedException {
        SocketAppenderTest.closeServer();
        this.socketAppender.setReconnectionDelay(1);
        this.configureClient();
        OnConsoleStatusListener.addNewInstanceToContext((Context)this.loggerContext);
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        SocketAppenderTest.fireServer();
        SocketAppenderTest.waitForServerToStart();
        this.updateListAppenderLatch(1);
        int len = 100;
        for (int i = 0; i < len; ++i) {
            logger.debug("test msg lateServerLaunch");
            if (!this.waitForListAppenderLatch()) continue;
            System.out.println("Success after " + i + " attempts");
            break;
        }
        Assert.assertTrue((String)"expecting non-empty list", (SocketAppenderTest.LIST_APPENDER.list.size() > 0 ? 1 : 0) != 0);
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertEquals((Object)"test msg lateServerLaunch", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    private static void waitForServerToStart() throws InterruptedException {
        CountDownLatch latch = SIMPLE_SOCKET_SERVER.getLatch();
        boolean success = latch.await(1000L, TimeUnit.MILLISECONDS);
        if (!success) {
            Assert.fail((String)"Failed latch wait for server to start");
        }
    }

    private static void fireServer() throws InterruptedException {
        SERVER_LOGGER_CONTEXT.reset();
        Logger root = SERVER_LOGGER_CONTEXT.getLogger("root");
        Logger socketNodeLogger = SERVER_LOGGER_CONTEXT.getLogger(SocketNode.class);
        socketNodeLogger.setLevel(Level.WARN);
        LIST_APPENDER.setName(LIST_APPENDER_NAME);
        LIST_APPENDER.setContext((Context)SERVER_LOGGER_CONTEXT);
        LIST_APPENDER.start();
        root.addAppender(LIST_APPENDER);
        SIMPLE_SOCKET_SERVER = new SimpleSocketServer(SERVER_LOGGER_CONTEXT, PORT);
        CountDownLatch latch = new CountDownLatch(1);
        SIMPLE_SOCKET_SERVER.setLatch(latch);
        SIMPLE_SOCKET_SERVER.start();
    }

    private void updateListAppenderLatch(int count) {
        LIST_APPENDER.setLatch(new CountDownLatch(count));
    }

    private boolean waitForListAppenderLatch() throws InterruptedException {
        CountDownLatch latch = LIST_APPENDER.getLatch();
        boolean success = latch.await(10L, TimeUnit.MILLISECONDS);
        return success;
    }

    private void configureClient() {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setName("test");
        this.loggerContext.putProperty("testKey", "testValue");
        Logger root = this.loggerContext.getLogger("ROOT");
        this.socketAppender.setContext((Context)this.loggerContext);
        this.socketAppender.setName("socket");
        this.socketAppender.setPort(PORT);
        this.socketAppender.setRemoteHost("localhost");
        this.socketAppender.setIncludeCallerData(this.includeCallerData);
        root.addAppender((Appender)this.socketAppender);
        this.socketAppender.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAppenderWithLatch<E>
    extends ListAppender<E> {
        CountDownLatch latch;

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }

        protected void append(E event) {
            super.append(event);
            try {
                this.latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

