/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.TeztHelper;
import ch.qos.logback.core.Context;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class RootCauseFirstThrowableProxyConverterTest {
    private LoggerContext context = new LoggerContext();
    private ThrowableProxyConverter converter = new RootCauseFirstThrowableProxyConverter();
    private StringWriter stringWriter = new StringWriter();
    private PrintWriter printWriter = new PrintWriter(this.stringWriter);

    @Before
    public void setUp() throws Exception {
        this.converter.setContext((Context)this.context);
        this.converter.start();
    }

    private ILoggingEvent createLoggingEvent(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.context.getLogger("ROOT"), Level.DEBUG, "test message", t, null);
    }

    @Test
    public void integration() {
        PatternLayout pl = new PatternLayout();
        pl.setContext((Context)this.context);
        pl.setPattern("%m%rEx%n");
        pl.start();
        ILoggingEvent e = this.createLoggingEvent(new Exception("x"));
        String result = pl.doLayout(e);
        Pattern p = Pattern.compile(" \\[junit.*\\]");
        Matcher m = p.matcher(result);
        int i = 0;
        while (m.find()) {
            ++i;
        }
        Assertions.assertThat((int)i).isGreaterThan(5);
    }

    @Test
    public void smoke() {
        Exception exception = new Exception("smoke");
        exception.printStackTrace(this.printWriter);
        ILoggingEvent le = this.createLoggingEvent(exception);
        String result = this.converter.convert(le);
        result = result.replace("common frames omitted", "more");
        result = result.replaceAll(" ~?\\[.*\\]", "");
        Assertions.assertThat((String)result).isEqualTo(this.stringWriter.toString());
    }

    @Test
    public void nested() {
        Throwable nestedException = TeztHelper.makeNestedException(2);
        nestedException.printStackTrace(this.printWriter);
        ILoggingEvent le = this.createLoggingEvent(nestedException);
        String result = this.converter.convert(le);
        Assertions.assertThat((String)result).startsWith("java.lang.Exception: nesting level=0");
        Assertions.assertThat((int)TeztHelper.positionOf("nesting level=0").in(result)).isLessThan(TeztHelper.positionOf("nesting level =1").in(result));
        Assertions.assertThat((int)TeztHelper.positionOf("nesting level =1").in(result)).isLessThan(TeztHelper.positionOf("nesting level =2").in(result));
    }
}

