/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.dom4j.io.SAXReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAppender_GreenTest {
    int port = RandomUtil.getRandomServerPort();
    GreenMail greenMail;
    SMTPAppender smtpAppender;
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(this.getClass());
    static final String TEST_SUBJECT = "test subject";
    static final String HEADER = "HEADER\n";
    static final String FOOTER = "FOOTER\n";

    @Before
    public void setUp() throws Exception {
        MDC.clear();
        ServerSetup serverSetup = new ServerSetup(this.port, "localhost", "smtp");
        this.greenMail = new GreenMail(serverSetup);
        this.greenMail.start();
        Thread.sleep(100L);
    }

    @After
    public void tearDown() throws Exception {
        this.greenMail.stop();
    }

    void buildSMTPAppender() throws Exception {
        this.smtpAppender = new SMTPAppender();
        this.smtpAppender.setContext((Context)this.lc);
        this.smtpAppender.setName("smtp");
        this.smtpAppender.setFrom("user@host.dom");
        this.smtpAppender.setSMTPHost("localhost");
        this.smtpAppender.setSMTPPort(this.port);
        this.smtpAppender.setSubject(TEST_SUBJECT);
        this.smtpAppender.addTo("nospam@qos.ch");
    }

    private Layout<ILoggingEvent> buildPatternLayout(LoggerContext lc) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader(HEADER);
        layout.setOutputPatternAsPresentationHeader(false);
        layout.setPattern("%-4relative %mdc [%thread] %-5level %class - %msg%n");
        layout.setFileFooter(FOOTER);
        layout.start();
        return layout;
    }

    private Layout<ILoggingEvent> buildHTMLLayout(LoggerContext lc) {
        HTMLLayout layout = new HTMLLayout();
        layout.setContext((Context)lc);
        layout.setPattern("%level%class%msg");
        layout.start();
        return layout;
    }

    private MimeMultipart verify(String subject) throws MessagingException, IOException {
        MimeMessage[] mma = this.greenMail.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)1L, (long)mma.length);
        MimeMessage mm = mma[0];
        Assert.assertEquals((Object)subject, (Object)mm.getSubject());
        return (MimeMultipart)mm.getContent();
    }

    void waitUntilEmailIsSent() throws InterruptedException {
        this.lc.getExecutorService().shutdown();
        this.lc.getExecutorService().awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void smoke() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        StatusPrinter.print((Context)this.lc);
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void LBCLASSIC_104() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        MDC.put((String)"key", (String)"val");
        this.logger.debug("hello");
        MDC.clear();
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.contains("key=val"));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void html() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildHTMLLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        reader.read(mp.getBodyPart(0).getInputStream());
    }

    @Test
    public void htmlLong() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildHTMLLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        for (int i = 0; i < 30000; ++i) {
            this.logger.debug("hello " + i);
        }
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(TEST_SUBJECT);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        reader.read(mp.getBodyPart(0).getInputStream());
    }

    private void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        System.out.println("port=" + this.port);
        this.lc.putProperty("port", "" + this.port);
        jc.doConfigure(file);
    }

    @Test
    public void testCustomEvaluator() throws Exception {
        this.configure("src/test/input/joran/smtp/customEvaluator.xml");
        this.logger.debug("hello");
        String msg2 = "world";
        this.logger.debug(msg2);
        this.logger.debug("invisible");
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(this.getClass().getName() + " - " + msg2);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertEquals((Object)"helloworld", (Object)body);
    }

    @Test
    public void testCustomBufferSize() throws Exception {
        this.configure("src/test/input/joran/smtp/customBufferSize.xml");
        this.logger.debug("invisible1");
        this.logger.debug("invisible2");
        String msg = "hello";
        this.logger.error(msg);
        this.waitUntilEmailIsSent();
        MimeMultipart mp = this.verify(this.getClass().getName() + " - " + msg);
        String body = GreenMailUtil.getBody((Part)mp.getBodyPart(0));
        Assert.assertEquals((Object)msg, (Object)body);
    }

    @Test
    public void testMultipleTo() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.addTo("Test <test@example.com>, other-test@example.com");
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        this.logger.debug("hello");
        this.logger.error("en error", (Throwable)new Exception("an exception"));
        this.waitUntilEmailIsSent();
        MimeMessage[] mma = this.greenMail.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)3L, (long)mma.length);
    }

    @Test
    public void bufferShouldBeResetBetweenMessages() throws Exception {
        this.buildSMTPAppender();
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        this.logger.addAppender((Appender)this.smtpAppender);
        String msg0 = "hello zero";
        this.logger.debug(msg0);
        this.logger.error("error zero");
        String msg1 = "hello one";
        this.logger.debug(msg1);
        this.logger.error("error one");
        this.waitUntilEmailIsSent();
        MimeMessage[] mma = this.greenMail.getReceivedMessages();
        Assert.assertNotNull((Object)mma);
        Assert.assertEquals((long)2L, (long)mma.length);
        MimeMessage mm0 = mma[0];
        MimeMultipart content0 = (MimeMultipart)mm0.getContent();
        String body0 = GreenMailUtil.getBody((Part)content0.getBodyPart(0));
        System.out.println(body0);
        System.out.println("--------------");
        MimeMessage mm1 = mma[1];
        MimeMultipart content1 = (MimeMultipart)mm1.getContent();
        String body1 = GreenMailUtil.getBody((Part)content1.getBodyPart(0));
        System.out.println(body1);
        Assert.assertFalse((boolean)body1.contains(msg0));
    }
}

