/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAppenderTest {
    static final String LIST_APPENDER_NAME = "la";
    static final int JOIN_OR_WAIT_TIMEOUT = 200;
    static final int SLEEP_AFTER_LOG = 100;
    int diff = RandomUtil.getPositiveInt();
    int port = 1024 + this.diff % 30000;
    String mdcKey = "key" + this.diff;
    LoggerContext lc = new LoggerContext();
    LoggerContext serverLC = new LoggerContext();
    ListAppender<ILoggingEvent> la = new ListAppender();
    SocketAppender socketAppender = new SocketAppender();
    private boolean includeCallerData = false;
    private SimpleSocketServer simpleSocketServer;

    @Before
    public void setUp() {
        System.out.println("SocketAppenderTest, start at " + System.currentTimeMillis() + ", port=" + this.port);
    }

    @Test
    public void startFailNoRemoteHost() {
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.lc);
        appender.setPort(this.port);
        appender.start();
        Assert.assertEquals((long)1L, (long)this.lc.getStatusManager().getCount());
    }

    @Test
    public void receiveMessage() throws InterruptedException {
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)this.la.list.get(0);
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertEquals((Object)"test msg", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    @Test
    public void receiveWithContext() throws InterruptedException {
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)this.la.list.get(0);
        String loggerName = remoteEvent.getLoggerName();
        Assert.assertNotNull((Object)loggerName);
        Assert.assertEquals((Object)"ROOT", (Object)loggerName);
        LoggerContextVO loggerContextRemoteView = remoteEvent.getLoggerContextVO();
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"test", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void messageWithMDC() throws InterruptedException {
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger root = this.lc.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        ListAppender<ILoggingEvent> la = this.getListAppender();
        Assert.assertEquals((long)1L, (long)la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)la.list.get(0);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get(this.mdcKey));
        Assert.assertNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void withCallerData() throws InterruptedException {
        this.includeCallerData = true;
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        ListAppender<ILoggingEvent> la = this.getListAppender();
        Assert.assertEquals((long)1L, (long)la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)la.list.get(0);
        Assert.assertNotNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void messageWithMarker() throws InterruptedException {
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger logger = this.lc.getLogger("ROOT");
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        logger.debug(marker, "test msg");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)this.la.list.get(0);
        Assert.assertEquals((Object)"testMarker", (Object)remoteEvent.getMarker().getName());
    }

    @Test
    public void messageWithUpdatedMDC() throws InterruptedException {
        this.fireServer();
        this.waitForServerToStart();
        this.configureClient();
        Logger root = this.lc.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        MDC.put((String)this.mdcKey, (String)"updatedTestValue");
        root.debug("test msg 2");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        this.simpleSocketServer.join(200L);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        ListAppender<ILoggingEvent> la = this.getListAppender();
        Assert.assertEquals((long)2L, (long)la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)la.list.get(1);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get(this.mdcKey));
    }

    @Test
    public void lateServerLaunch() throws InterruptedException {
        this.socketAppender.setReconnectionDelay(20);
        this.configureClient();
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test msg");
        this.fireServer();
        this.waitForServerToStart();
        Thread.sleep(100L);
        logger.debug("test msg 2");
        Thread.sleep(100L);
        this.simpleSocketServer.close();
        Thread.sleep(100L);
        this.simpleSocketServer.join(200L);
        StatusPrinter.print((Context)this.lc);
        Assert.assertTrue((boolean)this.simpleSocketServer.isClosed());
        Assert.assertEquals((long)1L, (long)this.la.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)this.la.list.get(0);
        Assert.assertEquals((Object)"test msg 2", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerToStart() throws InterruptedException {
        SimpleSocketServer simpleSocketServer = this.simpleSocketServer;
        synchronized (simpleSocketServer) {
            this.simpleSocketServer.wait(200L);
        }
    }

    private void fireServer() throws InterruptedException {
        Logger root = this.serverLC.getLogger("root");
        Logger socketNodeLogger = this.serverLC.getLogger(SocketNode.class);
        socketNodeLogger.setLevel(Level.WARN);
        this.la.setName(LIST_APPENDER_NAME);
        this.la.setContext((Context)this.serverLC);
        this.la.start();
        root.addAppender(this.la);
        this.simpleSocketServer = new SimpleSocketServer(this.serverLC, this.port);
        this.simpleSocketServer.start();
        Thread.yield();
        Thread.sleep(50L);
    }

    ListAppender<ILoggingEvent> getListAppender() {
        Logger root = this.serverLC.getLogger("root");
        return (ListAppender)root.getAppender(LIST_APPENDER_NAME);
    }

    private void configureClient() {
        this.lc = new LoggerContext();
        this.lc.setName("test");
        this.lc.putProperty("testKey", "testValue");
        Logger root = this.lc.getLogger("ROOT");
        this.socketAppender.setContext((Context)this.lc);
        this.socketAppender.setName("socket");
        this.socketAppender.setPort(this.port);
        this.socketAppender.setRemoteHost("localhost");
        this.socketAppender.setIncludeCallerData(this.includeCallerData);
        root.addAppender((Appender)this.socketAppender);
        this.socketAppender.start();
    }
}

