/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackMDCAdapterTest {
    static final String A_SUFFIX = "A_SUFFIX";
    static final String B_SUFFIX = "B_SUFFIX";
    int diff = RandomUtil.getPositiveInt();
    private final LogbackMDCAdapter mdcAdapter = new LogbackMDCAdapter();

    @Test
    public void lbclassic77Test() throws InterruptedException {
        Map<String, String> parentHM = this.getMapFromMDCAdapter(this.mdcAdapter);
        Assert.assertNull(parentHM);
        ChildThreadForMDCAdapter childThread = new ChildThreadForMDCAdapter(this.mdcAdapter);
        childThread.start();
        childThread.join();
        Assert.assertTrue((boolean)childThread.successul);
        Assert.assertNull(childThread.childHM);
    }

    @Test
    public void removeForNullKeyTest() {
        this.mdcAdapter.remove(null);
    }

    @Test
    public void removeInexistentKey() {
        this.mdcAdapter.remove("abcdlw0");
    }

    @Test
    public void sequenceWithGet() {
        this.mdcAdapter.put("k0", "v0");
        Map map0 = (Map)this.mdcAdapter.copyOnInheritThreadLocal.get();
        this.mdcAdapter.get("k0");
        this.mdcAdapter.put("k0", "v1");
        Assert.assertEquals((Object)"v0", map0.get("k0"));
    }

    @Test
    public void sequenceWithGetPropertyMap() {
        this.mdcAdapter.put("k0", "v0");
        Map map0 = this.mdcAdapter.getPropertyMap();
        this.mdcAdapter.put("k0", "v1");
        Assert.assertEquals((Object)"v0", map0.get("k0"));
    }

    @Test
    public void copyOnInheritenceTest() throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        String firstKey = "x" + this.diff;
        String secondKey = "o" + this.diff;
        this.mdcAdapter.put(firstKey, firstKey + A_SUFFIX);
        ChildThread childThread = new ChildThread(this.mdcAdapter, firstKey, secondKey, countDownLatch);
        childThread.start();
        countDownLatch.await();
        this.mdcAdapter.put(firstKey, firstKey + B_SUFFIX);
        childThread.join();
        Assert.assertNull((Object)this.mdcAdapter.get(secondKey));
        Assert.assertTrue((boolean)childThread.successful);
        Map<String, String> parentHM = this.getMapFromMDCAdapter(this.mdcAdapter);
        Assert.assertTrue((parentHM != childThread.childHM ? 1 : 0) != 0);
        HashMap<String, String> parentHMWitness = new HashMap<String, String>();
        parentHMWitness.put(firstKey, firstKey + B_SUFFIX);
        Assert.assertEquals(parentHMWitness, parentHM);
        HashMap<String, String> childHMWitness = new HashMap<String, String>();
        childHMWitness.put(firstKey, firstKey + A_SUFFIX);
        childHMWitness.put(secondKey, secondKey + A_SUFFIX);
        Assert.assertEquals(childHMWitness, childThread.childHM);
    }

    @Test
    public void clearOnChildThreadShouldNotAffectParent() throws InterruptedException {
        String firstKey = "x" + this.diff;
        String secondKey = "o" + this.diff;
        this.mdcAdapter.put(firstKey, firstKey + A_SUFFIX);
        Assert.assertEquals((Object)(firstKey + A_SUFFIX), (Object)this.mdcAdapter.get(firstKey));
        ChildThread clearer = new ChildThread(this.mdcAdapter, firstKey, secondKey){

            public void run() {
                LogbackMDCAdapterTest.this.mdcAdapter.clear();
                Assert.assertNull((Object)LogbackMDCAdapterTest.this.mdcAdapter.get(this.firstKey));
            }
        };
        clearer.start();
        clearer.join();
        Assert.assertEquals((Object)(firstKey + A_SUFFIX), (Object)this.mdcAdapter.get(firstKey));
    }

    @Test
    public void nearSimultaneousPutsShouldNotCauseConcurrentModificationException() throws InterruptedException {
        for (int i = 0; i < 2048; ++i) {
            this.mdcAdapter.put("k" + i, "v" + i);
        }
        ChildThread childThread = new ChildThread(this.mdcAdapter, null, null){

            public void run() {
                for (int i = 0; i < 16; ++i) {
                    LogbackMDCAdapterTest.this.mdcAdapter.put("ck" + i, "cv" + i);
                    Thread.yield();
                }
                this.successful = true;
            }
        };
        childThread.start();
        Thread.sleep(1L);
        for (int i = 0; i < 16; ++i) {
            this.mdcAdapter.put("K" + i, "V" + i);
        }
        childThread.join();
        Assert.assertTrue((boolean)childThread.successful);
    }

    Map<String, String> getMapFromMDCAdapter(LogbackMDCAdapter lma) {
        InheritableThreadLocal copyOnInheritThreadLocal = lma.copyOnInheritThreadLocal;
        return (Map)copyOnInheritThreadLocal.get();
    }

    class ChildThread
    extends Thread {
        LogbackMDCAdapter logbackMDCAdapter;
        String firstKey;
        String secondKey;
        boolean successful;
        Map<String, String> childHM;
        CountDownLatch countDownLatch;

        ChildThread(LogbackMDCAdapter logbackMDCAdapter) {
            this(logbackMDCAdapter, null, null);
        }

        ChildThread(LogbackMDCAdapter logbackMDCAdapter, String firstKey, String secondKey) {
            this(logbackMDCAdapter, firstKey, secondKey, null);
        }

        ChildThread(LogbackMDCAdapter logbackMDCAdapter, String firstKey, String secondKey, CountDownLatch countDownLatch) {
            super("chil");
            this.logbackMDCAdapter = logbackMDCAdapter;
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.countDownLatch = countDownLatch;
        }

        public void run() {
            this.logbackMDCAdapter.put(this.secondKey, this.secondKey + LogbackMDCAdapterTest.A_SUFFIX);
            Assert.assertNotNull((Object)this.logbackMDCAdapter.get(this.firstKey));
            Assert.assertEquals((Object)(this.firstKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)this.logbackMDCAdapter.get(this.firstKey));
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
            Assert.assertEquals((Object)(this.secondKey + LogbackMDCAdapterTest.A_SUFFIX), (Object)this.logbackMDCAdapter.get(this.secondKey));
            this.successful = true;
            this.childHM = LogbackMDCAdapterTest.this.getMapFromMDCAdapter(this.logbackMDCAdapter);
        }
    }

    class ChildThreadForMDCAdapter
    extends Thread {
        LogbackMDCAdapter logbackMDCAdapter;
        boolean successul;
        Map<String, String> childHM;

        ChildThreadForMDCAdapter(LogbackMDCAdapter logbackMDCAdapter) {
            this.logbackMDCAdapter = logbackMDCAdapter;
        }

        public void run() {
            this.childHM = LogbackMDCAdapterTest.this.getMapFromMDCAdapter(this.logbackMDCAdapter);
            this.logbackMDCAdapter.get("");
            this.successul = true;
        }
    }
}

