/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.IfAction;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.Assert;
import org.junit.Test;

public class ConditionalWithoutJanino {
    LoggerContext loggerContext = new LoggerContext();
    Logger root = this.loggerContext.getLogger("ROOT");

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void condtionalWithoutJanino() throws JoranException {
        String configFile = "src/test/input/joran/conditional/withoutJanino.xml";
        String currentDir = System.getProperty("user.dir");
        if (!currentDir.contains("logback-classic")) {
            configFile = "logback-classic/" + configFile;
        }
        this.configure(configFile);
        StatusPrinter.print((Context)this.loggerContext);
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        Assert.assertTrue((boolean)checker.containsMatch(IfAction.MISSING_JANINO_MSG));
        Assert.assertSame((Object)Level.WARN, (Object)this.loggerContext.getLogger("a").getLevel());
        Assert.assertSame((Object)Level.WARN, (Object)this.root.getLevel());
    }
}

