/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jul;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelChangePropagatorTest {
    int rand = RandomUtil.getPositiveInt();
    LoggerContext loggerContext = new LoggerContext();
    LevelChangePropagator levelChangePropagator = new LevelChangePropagator();

    @Before
    public void setUp() {
        this.levelChangePropagator.setContext((Context)this.loggerContext);
        this.loggerContext.addListener((LoggerContextListener)this.levelChangePropagator);
    }

    void checkLevelChange(String loggerName, Level level) {
        Logger logger = this.loggerContext.getLogger(loggerName);
        logger.setLevel(level);
        java.util.logging.Logger julLogger = JULHelper.asJULLogger((Logger)logger);
        java.util.logging.Level julLevel = JULHelper.asJULLevel((Level)level);
        Assert.assertEquals((Object)julLevel, (Object)julLogger.getLevel());
    }

    @Test
    public void smoke() {
        this.checkLevelChange("a", Level.INFO);
        this.checkLevelChange("a.b", Level.DEBUG);
    }

    @Test
    public void root() {
        this.checkLevelChange("ROOT", Level.TRACE);
    }

    @Test
    public void gc() {
        Logger logger = this.loggerContext.getLogger("gc" + this.rand);
        logger.setLevel(Level.INFO);
        System.gc();
        java.util.logging.Logger julLogger = JULHelper.asJULLogger((Logger)logger);
        java.util.logging.Level julLevel = JULHelper.asJULLevel((Level)Level.INFO);
        Assert.assertEquals((Object)julLevel, (Object)julLogger.getLevel());
    }
}

