/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.testObjectBuilders.LoggingEventBuilderInContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class AsyncAppenderTest {
    String thisClassName = this.getClass().getName();
    LoggerContext context = new LoggerContext();
    AsyncAppender asyncAppender = new AsyncAppender();
    ListAppender<ILoggingEvent> listAppender = new ListAppender();
    OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
    StatusChecker statusChecker = new StatusChecker((Context)this.context);
    LoggingEventBuilderInContext builder = new LoggingEventBuilderInContext(this.context, this.thisClassName, UnsynchronizedAppenderBase.class.getName());
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() {
        this.onConsoleStatusListener.setContext((Context)this.context);
        this.context.getStatusManager().add((StatusListener)this.onConsoleStatusListener);
        this.onConsoleStatusListener.start();
        this.asyncAppender.setContext((Context)this.context);
        this.listAppender.setContext((Context)this.context);
        this.listAppender.setName("list");
        this.listAppender.start();
    }

    @Test
    public void eventWasPreparedForDeferredProcessing() {
        this.asyncAppender.addAppender(this.listAppender);
        this.asyncAppender.start();
        String k = "k" + this.diff;
        MDC.put((String)k, (String)"v");
        this.asyncAppender.doAppend((Object)this.builder.build(this.diff));
        MDC.clear();
        this.asyncAppender.stop();
        Assert.assertFalse((boolean)this.asyncAppender.isStarted());
        Assert.assertEquals((long)1L, (long)this.listAppender.list.size());
        ILoggingEvent e = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertEquals((Object)"v", e.getMDCPropertyMap().get(k));
        Assert.assertFalse((boolean)e.hasCallerData());
    }

    @Test
    public void settingIncludeCallerDataPropertyCausedCallerDataToBeIncluded() {
        this.asyncAppender.addAppender(this.listAppender);
        this.asyncAppender.setIncludeCallerData(true);
        this.asyncAppender.start();
        this.asyncAppender.doAppend((Object)this.builder.build(this.diff));
        this.asyncAppender.stop();
        Assert.assertEquals((long)1L, (long)this.listAppender.list.size());
        ILoggingEvent e = (ILoggingEvent)this.listAppender.list.get(0);
        Assert.assertTrue((boolean)e.hasCallerData());
        StackTraceElement ste = e.getCallerData()[0];
        Assert.assertEquals((Object)this.thisClassName, (Object)ste.getClassName());
    }
}

