/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SocketAppenderTest {
    static final String LIST_APPENDER_NAME = "list";
    static final int RECONNECT_DELAY = 1;
    static int diff = RandomUtil.getPositiveInt();
    static int PORT = 1024 + diff % 30000;
    String mdcKey = "key" + diff;
    LoggerContext loggerContext = new LoggerContext();
    static LoggerContext serverLoggerContext = new LoggerContext();
    static CountDownLatch LIST_APPENDER_COUNTDOWN_LATCH;
    static ListAppenderWithLatch<ILoggingEvent> LIST_APPENDER;
    SocketAppender socketAppender = new SocketAppender();
    private boolean includeCallerData = false;
    private static SimpleSocketServer SIMPLE_SOCKET_SERVER;

    @BeforeClass
    public static void beforeClass() throws InterruptedException {
        SocketAppenderTest.fireServer();
        SocketAppenderTest.waitForServerToStart();
    }

    @AfterClass
    public static void afterClass() {
        SocketAppenderTest.closeServer();
    }

    private static void closeServer() {
        SIMPLE_SOCKET_SERVER.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        SocketAppenderTest.LIST_APPENDER.list.clear();
    }

    @Test
    public void startFailNoRemoteHost() {
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.loggerContext);
        appender.setPort(PORT);
        appender.start();
        Assert.assertEquals((long)1L, (long)this.loggerContext.getStatusManager().getCount());
    }

    @Test
    public void receiveMessage() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertEquals((Object)"test msg", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    @Test
    public void receiveWithContext() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        String loggerName = remoteEvent.getLoggerName();
        Assert.assertNotNull((Object)loggerName);
        Assert.assertEquals((Object)"ROOT", (Object)loggerName);
        LoggerContextVO loggerContextRemoteView = remoteEvent.getLoggerContextVO();
        Assert.assertNull((Object)remoteEvent.getCallerData());
        Assert.assertNotNull((Object)loggerContextRemoteView);
        Assert.assertEquals((Object)"test", (Object)loggerContextRemoteView.getName());
        Map props = loggerContextRemoteView.getPropertyMap();
        Assert.assertEquals((Object)"testValue", props.get("testKey"));
    }

    @Test
    public void messageWithMDC() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger root = this.loggerContext.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"testValue", MDCPropertyMap.get(this.mdcKey));
        Assert.assertNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void withCallerData() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.includeCallerData = true;
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertNotNull((Object)remoteEvent.getCallerData());
    }

    @Test
    public void messageWithMarker() throws InterruptedException {
        this.updateListAppenderLatch(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        logger.debug(marker, "test msg");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertEquals((Object)"testMarker", (Object)remoteEvent.getMarker().getName());
    }

    @Test
    public void messageWithUpdatedMDC() throws InterruptedException {
        this.updateListAppenderLatch(2);
        this.configureClient();
        Logger root = this.loggerContext.getLogger("ROOT");
        MDC.put((String)this.mdcKey, (String)"testValue");
        root.debug("test msg");
        MDC.put((String)this.mdcKey, (String)"updatedTestValue");
        root.debug("test msg 2");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)2L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(1);
        Map MDCPropertyMap = remoteEvent.getMDCPropertyMap();
        Assert.assertEquals((Object)"updatedTestValue", MDCPropertyMap.get(this.mdcKey));
    }

    @Test
    public void lateServerLaunch() throws InterruptedException {
        SocketAppenderTest.closeServer();
        this.socketAppender.setReconnectionDelay(1);
        this.configureClient();
        Logger logger = this.loggerContext.getLogger("ROOT");
        logger.debug("test msg");
        SocketAppenderTest.fireServer();
        SocketAppenderTest.waitForServerToStart();
        this.updateListAppenderLatch(1);
        Thread.sleep(200L);
        logger.debug("test msg 2");
        this.waitForListAppenderLatch();
        Assert.assertEquals((long)1L, (long)SocketAppenderTest.LIST_APPENDER.list.size());
        ILoggingEvent remoteEvent = (ILoggingEvent)SocketAppenderTest.LIST_APPENDER.list.get(0);
        Assert.assertEquals((Object)"test msg 2", (Object)remoteEvent.getMessage());
        Assert.assertEquals((Object)Level.DEBUG, (Object)remoteEvent.getLevel());
    }

    private static void waitForServerToStart() throws InterruptedException {
        SIMPLE_SOCKET_SERVER.getLatch().await(100L, TimeUnit.MILLISECONDS);
    }

    private static void fireServer() throws InterruptedException {
        serverLoggerContext.reset();
        Logger root = serverLoggerContext.getLogger("root");
        Logger socketNodeLogger = serverLoggerContext.getLogger(SocketNode.class);
        socketNodeLogger.setLevel(Level.WARN);
        LIST_APPENDER.setName(LIST_APPENDER_NAME);
        LIST_APPENDER.setContext((Context)serverLoggerContext);
        LIST_APPENDER.start();
        root.addAppender(LIST_APPENDER);
        SIMPLE_SOCKET_SERVER = new SimpleSocketServer(serverLoggerContext, PORT);
        SIMPLE_SOCKET_SERVER.setLatch(new CountDownLatch(1));
        SIMPLE_SOCKET_SERVER.start();
    }

    private void updateListAppenderLatch(int count) {
        LIST_APPENDER_COUNTDOWN_LATCH = new CountDownLatch(count);
    }

    private void waitForListAppenderLatch() {
        try {
            LIST_APPENDER_COUNTDOWN_LATCH.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("problem while waiting for barrier", e);
        }
    }

    private void configureClient() {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setName("test");
        this.loggerContext.putProperty("testKey", "testValue");
        Logger root = this.loggerContext.getLogger("ROOT");
        this.socketAppender.setContext((Context)this.loggerContext);
        this.socketAppender.setName("socket");
        this.socketAppender.setPort(PORT);
        this.socketAppender.setRemoteHost("localhost");
        this.socketAppender.setIncludeCallerData(this.includeCallerData);
        root.addAppender((Appender)this.socketAppender);
        this.socketAppender.start();
    }

    static {
        LIST_APPENDER = new ListAppenderWithLatch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAppenderWithLatch<E>
    extends ListAppender<E> {
        protected void append(E event) {
            System.out.println("got: " + event);
            super.append(event);
            try {
                LIST_APPENDER_COUNTDOWN_LATCH.countDown();
            }
            catch (Exception exeption) {
                exeption.printStackTrace();
            }
        }
    }
}

