/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.db.DBAppenderH2TestFixture;
import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.MDC;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DBAppenderH2Test {
    LoggerContext lc;
    Logger logger;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;
    DBAppenderH2TestFixture dbAppenderH2TestFixture;
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() throws SQLException {
        this.dbAppenderH2TestFixture = new DBAppenderH2TestFixture();
        this.dbAppenderH2TestFixture.setUp();
        this.lc = new LoggerContext();
        this.lc.setName("default");
        this.logger = this.lc.getLogger("root");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.lc);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.lc);
        this.connectionSource.setDriverClass("org.h2.Driver");
        this.connectionSource.setUrl(this.dbAppenderH2TestFixture.url);
        System.out.println("cs.url=" + this.dbAppenderH2TestFixture.url);
        this.connectionSource.setUser(this.dbAppenderH2TestFixture.user);
        this.connectionSource.setPassword(this.dbAppenderH2TestFixture.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
        this.appender.start();
    }

    @After
    public void tearDown() throws SQLException {
        this.logger = null;
        this.lc = null;
        this.appender = null;
        this.connectionSource = null;
        this.dbAppenderH2TestFixture.tearDown();
    }

    @Test
    public void testAppendLoggingEvent() throws SQLException {
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        StatusPrinter.print((Context)this.lc);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        if (rs.next()) {
            Assert.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            Assert.assertEquals((Object)event.getFormattedMessage(), (Object)rs.getString(2));
            Assert.assertEquals((Object)event.getLoggerName(), (Object)rs.getString(3));
            Assert.assertEquals((Object)event.getLevel().toString(), (Object)rs.getString(4));
            Assert.assertEquals((Object)event.getThreadName(), (Object)rs.getString(5));
            Assert.assertEquals((long)DBHelper.computeReferenceMask((ILoggingEvent)event), (long)rs.getShort(6));
            Assert.assertEquals((Object)String.valueOf(this.diff), (Object)rs.getString(7));
            StackTraceElement callerData = event.getCallerData()[0];
            Assert.assertEquals((Object)callerData.getFileName(), (Object)rs.getString(11));
            Assert.assertEquals((Object)callerData.getClassName(), (Object)rs.getString(12));
            Assert.assertEquals((Object)callerData.getMethodName(), (Object)rs.getString(13));
        } else {
            Assert.fail((String)"No row was inserted in the database");
        }
        rs.close();
        stmt.close();
    }

    @Test
    public void testAppendThrowable() throws SQLException {
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM LOGGING_EVENT_EXCEPTION WHERE EVENT_ID=1");
        rs.next();
        String expected = "java.lang.Exception: test Ex";
        String firstLine = rs.getString(3);
        Assert.assertTrue((String)("[" + firstLine + "] does not match [" + expected + "]"), (boolean)firstLine.contains(expected));
        int i = 0;
        while (rs.next()) {
            expected = event.getThrowableProxy().getStackTraceElementProxyArray()[i].toString();
            String st = rs.getString(3);
            Assert.assertTrue((String)("[" + st + "] does not match [" + expected + "]"), (boolean)st.contains(expected));
            ++i;
        }
        Assert.assertTrue((i != 0 ? 1 : 0) != 0);
        rs.close();
        stmt.close();
    }

    @Test
    public void withNullArgument() throws SQLException {
        ILoggingEvent event = this.createLoggingEvent("Processing code {}; code type is {}; request date {}; record from date {}", new Object[]{1, 2, new Date(), null});
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        if (rs.next()) {
            Assert.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            Assert.assertEquals((Object)event.getFormattedMessage(), (Object)rs.getString(2));
        }
        StatusPrinter.print((Context)this.lc);
    }

    @Test
    public void testContextInfo() throws SQLException {
        this.lc.putProperty("testKey1", "testValue1");
        MDC.put((String)("k" + this.diff), (String)("v" + this.diff));
        ILoggingEvent event = this.createLoggingEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM LOGGING_EVENT_PROPERTY WHERE EVENT_ID=1");
        Map map = this.appender.mergePropertyMaps(event);
        int i = 0;
        while (rs.next()) {
            String key = rs.getString(2);
            Assert.assertEquals(map.get(key), (Object)rs.getString(3));
            ++i;
        }
        Assert.assertTrue((map.size() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)map.size(), (long)i);
        rs.close();
        stmt.close();
    }

    @Test
    public void testAppendMultipleEvents() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            ILoggingEvent event = this.createLoggingEvent();
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM logging_event");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        rs.close();
        stmt.close();
    }

    private ILoggingEvent createLoggingEvent(String msg, Object[] args) {
        return new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, msg, (Throwable)new Exception("test Ex"), args);
    }

    private ILoggingEvent createLoggingEvent() {
        return this.createLoggingEvent("test message", new Integer[]{this.diff});
    }
}

