/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatternLayoutEncoderTest {
    PatternLayoutEncoder ple = new PatternLayoutEncoder();
    LoggerContext context = new LoggerContext();
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    Logger logger = this.context.getLogger(PatternLayoutEncoderTest.class);
    Charset utf8Charset = Charset.forName("UTF-8");

    @Before
    public void setUp() {
        this.ple.setPattern("%m");
        this.ple.setContext((Context)this.context);
    }

    ILoggingEvent makeLoggingEvent(String message) {
        return new LoggingEvent("", this.logger, Level.DEBUG, message, null, null);
    }

    @Test
    public void smoke() throws IOException {
        this.init(this.baos);
        String msg = "hello";
        ILoggingEvent event = this.makeLoggingEvent(msg);
        this.ple.doEncode((Object)event);
        this.ple.close();
        Assert.assertEquals((Object)msg, (Object)this.baos.toString());
    }

    void init(ByteArrayOutputStream baos) throws IOException {
        this.ple.start();
        ((PatternLayout)this.ple.getLayout()).setOutputPatternAsHeader(false);
        this.ple.init((OutputStream)baos);
    }

    @Test
    public void charset() throws IOException {
        this.ple.setCharset(this.utf8Charset);
        this.init(this.baos);
        String msg = "\u03b1";
        ILoggingEvent event = this.makeLoggingEvent(msg);
        this.ple.doEncode((Object)event);
        this.ple.close();
        Assert.assertEquals((Object)msg, (Object)new String(this.baos.toByteArray(), this.utf8Charset.name()));
    }
}

