/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.mock.MockAppender;
import ch.qos.logback.classic.net.server.RemoteAppenderStreamClient;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LoggingEventVO;
import ch.qos.logback.core.Appender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class RemoteAppenderStreamClientTest {
    private MockAppender appender;
    private Logger logger;
    private LoggingEvent event;
    private RemoteAppenderStreamClient client;

    @Before
    public void setUp() throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.appender = new MockAppender();
        this.appender.start();
        this.logger = lc.getLogger(this.getClass());
        this.logger.addAppender((Appender)this.appender);
        this.event = new LoggingEvent(this.logger.getName(), this.logger, Level.DEBUG, "test message", null, new Object[0]);
        LoggingEventVO eventVO = LoggingEventVO.build((ILoggingEvent)this.event);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(eventVO);
        oos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        this.client = new RemoteAppenderStreamClient("some client ID", (InputStream)bis);
        this.client.setLoggerContext(lc);
    }

    @Test
    public void testWithEnabledLevel() throws Exception {
        this.logger.setLevel(Level.DEBUG);
        this.client.run();
        this.client.close();
        ILoggingEvent rcvdEvent = this.appender.getLastEvent();
        Assert.assertEquals((Object)this.event.getLoggerName(), (Object)rcvdEvent.getLoggerName());
        Assert.assertEquals((Object)this.event.getLevel(), (Object)rcvdEvent.getLevel());
        Assert.assertEquals((Object)this.event.getMessage(), (Object)rcvdEvent.getMessage());
    }

    @Test
    public void testWithDisabledLevel() throws Exception {
        this.logger.setLevel(Level.INFO);
        this.client.run();
        this.client.close();
        Assert.assertNull((Object)this.appender.getLastEvent());
    }
}

