/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.MDC;

public class DBAppenderIntegrationTest {
    static String LOCAL_HOST_NAME;
    static String[] CONFORMING_HOST_LIST;
    static String[] POSTGRES_CONFORMING_HOST_LIST;
    static String[] MYSQL_CONFORMING_HOST_LIST;
    static String[] ORACLE_CONFORMING_HOST_LIST;
    int diff = RandomUtil.getPositiveInt();
    LoggerContext lc = new LoggerContext();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        InetAddress localhostIA = InetAddress.getLocalHost();
        LOCAL_HOST_NAME = localhostIA.getHostName();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.lc.setName("lc" + this.diff);
    }

    @After
    public void tearDown() throws Exception {
        this.lc.stop();
    }

    DriverManagerConnectionSource getConnectionSource() {
        Logger root = this.lc.getLogger("ROOT");
        DBAppender dbAppender = (DBAppender)root.getAppender("DB");
        Assert.assertNotNull((Object)dbAppender);
        return (DriverManagerConnectionSource)dbAppender.getConnectionSource();
    }

    public void doTest(String configFile) throws JoranException, SQLException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.lc);
        configurator.doConfigure(configFile);
        Logger logger = this.lc.getLogger(DBAppenderIntegrationTest.class);
        MDC.put((String)("userid" + this.diff), (String)("user" + this.diff));
        int runLength = 5;
        for (int i = 1; i <= runLength; ++i) {
            logger.debug("This is a debug message. Message number: " + (this.diff + i));
        }
        Exception e = new Exception("Just testing", this.getCause());
        logger.error("At last an error.", (Throwable)e);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.lc);
        long lastEventId = this.getLastEventId();
        this.verify(lastEventId);
        StatusChecker checker = new StatusChecker((Context)this.lc);
        checker.assertIsErrorFree();
    }

    long getLastEventId() throws SQLException {
        DriverManagerConnectionSource cs = this.getConnectionSource();
        Connection con = cs.getConnection();
        Statement statement = con.createStatement();
        statement.setMaxRows(1);
        ResultSet rs = statement.executeQuery("select event_id from logging_event order by event_id desc");
        rs.next();
        long eventId = rs.getLong(1);
        rs.close();
        statement.close();
        return eventId;
    }

    void verify(long lastEventId) throws SQLException {
        this.verifyDebugMsg(lastEventId);
        this.verifyException(lastEventId);
        this.verifyProperty(lastEventId);
    }

    void verifyDebugMsg(long lastEventId) throws SQLException {
        DriverManagerConnectionSource cs = this.getConnectionSource();
        Connection con = cs.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("select formatted_message from logging_event where event_id='" + (lastEventId - 1L) + "'");
        rs.next();
        String msg = rs.getString(1);
        Assert.assertEquals((Object)("This is a debug message. Message number: " + (this.diff + 5)), (Object)msg);
    }

    void verifyProperty(long lastEventId) throws SQLException {
        DriverManagerConnectionSource cs = this.getConnectionSource();
        Connection con = cs.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("select mapped_key, mapped_value from logging_event_property where event_id='" + (lastEventId - 1L) + "'");
        Map witness = this.lc.getCopyOfPropertyMap();
        witness.putAll(MDC.getCopyOfContextMap());
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            String key = rs.getString(1);
            String val = rs.getString(2);
            map.put(key, val);
        }
        Assert.assertEquals((Object)witness, map);
    }

    void verifyException(long lastEventId) throws SQLException {
        DriverManagerConnectionSource cs = this.getConnectionSource();
        Connection con = cs.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("select trace_line from logging_event_exception where event_id='" + lastEventId + "' AND I='0'");
        rs.next();
        String traceLine = rs.getString(1);
        Assert.assertEquals((Object)"java.lang.Exception: Just testing", (Object)traceLine);
    }

    Throwable getCause() {
        return new IllegalStateException("test cause");
    }

    static boolean isConformingHostAndJDK16OrHigher(String[] conformingHostList) {
        if (!EnvUtil.isJDK6OrHigher()) {
            return false;
        }
        for (String conformingHost : conformingHostList) {
            if (!conformingHost.equalsIgnoreCase(LOCAL_HOST_NAME)) continue;
            return true;
        }
        return false;
    }

    static boolean isConformingHostAndJDK16OrHigher() {
        return DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher(CONFORMING_HOST_LIST);
    }

    @Test
    public void sqlserver() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/sqlserver-with-driver.xml");
    }

    @Test
    public void oracle10g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher(ORACLE_CONFORMING_HOST_LIST)) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle10g-with-driver.xml");
    }

    @Test
    @Ignore
    public void oracle11g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle11g-with-driver.xml");
    }

    @Test
    public void mysql() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher(MYSQL_CONFORMING_HOST_LIST)) {
            return;
        }
        this.doTest("src/test/input/integration/db/mysql-with-driver.xml");
    }

    @Test
    public void postgres() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher(POSTGRES_CONFORMING_HOST_LIST)) {
            return;
        }
        System.out.println("running postgres() test");
        this.doTest("src/test/input/integration/db/postgresql-with-driver.xml");
    }

    static {
        CONFORMING_HOST_LIST = new String[]{"Orion"};
        POSTGRES_CONFORMING_HOST_LIST = new String[]{"haro"};
        MYSQL_CONFORMING_HOST_LIST = new String[]{"xharo"};
        ORACLE_CONFORMING_HOST_LIST = new String[]{"xharo"};
    }
}

