/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.ClassicConstants;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiftingAppenderTest {
    static String SIFT_FOLDER_PREFIX = "src/test/input/joran/sift/";
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("ROOT");
    StatusChecker statusChecker = new StatusChecker((Context)this.loggerContext);
    int diff = RandomUtil.getPositiveInt();
    int now = 0;

    protected void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void unsetDefaultValueProperty() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "unsetDefaultValueProperty.xml");
        this.logger.debug("hello");
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        Assert.assertFalse((boolean)sa.isStarted());
    }

    @Test
    public void smoke() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "smoke.xml");
        this.logger.debug("smoke");
        Appender appender = (Appender)this.getAppenderTracker().find("smokeDefault");
        Assert.assertNotNull((Object)appender);
        ListAppender listAppender = (ListAppender)appender;
        List eventList = listAppender.list;
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        Assert.assertEquals((Object)"smoke", (Object)((ILoggingEvent)eventList.get(0)).getMessage());
    }

    private AppenderTracker<ILoggingEvent> getAppenderTracker() {
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        return ha.getAppenderTracker();
    }

    @Test
    public void zeroNesting() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "zeroNesting.xml");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        Appender appender = (Appender)this.getAppenderTracker().find("zeroDefault");
        Assert.assertNotNull((Object)appender);
        NOPAppender nopa = (NOPAppender)appender;
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.loggerContext);
        this.statusChecker.assertContainsMatch(2, "No nested appenders found");
    }

    @Test
    public void multipleNesting() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "multipleNesting.xml");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        Appender listAppender = (Appender)this.getAppenderTracker().find("multipleDefault");
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.loggerContext);
        Assert.assertNotNull((Object)listAppender);
        this.statusChecker.assertContainsMatch(2, "Only and only one appender can be nested");
    }

    @Test
    public void defaultLayoutRule() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "defaultLayoutRule.xml");
        this.logger.debug("hello");
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)ha.getAppenderTracker().find("default");
        Assert.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assert.assertEquals((long)1L, (long)strList.size());
        Assert.assertEquals((Object)"DEBUG hello", strList.get(0));
    }

    @Test
    public void testWholeCycle() throws JoranException {
        String mdcKey = "cycle";
        this.configure(SIFT_FOLDER_PREFIX + "completeCycle.xml");
        MDC.put((String)mdcKey, (String)"a");
        this.logger.debug("smoke");
        long timestamp = System.currentTimeMillis();
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        ListAppender listAppender = (ListAppender)sa.getAppenderTracker().find("a");
        Assert.assertNotNull((Object)listAppender);
        List eventList = listAppender.list;
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        Assert.assertEquals((Object)"smoke", (Object)((ILoggingEvent)eventList.get(0)).getMessage());
        MDC.remove((String)mdcKey);
        LoggingEvent le = new LoggingEvent("x", this.logger, Level.INFO, "hello", null, null);
        le.setTimeStamp(timestamp + 1800000L + 1L);
        sa.doAppend((Object)le);
        Assert.assertFalse((boolean)listAppender.isStarted());
        Assert.assertEquals((long)1L, (long)sa.getAppenderTracker().allKeys().size());
        Assert.assertTrue((boolean)sa.getAppenderTracker().allKeys().contains("cycleDefault"));
    }

    @Test
    public void sessionFinalizationShouldCauseLingering() throws JoranException {
        String mdcKey = "linger";
        String mdcVal = "session" + this.diff;
        this.configure(SIFT_FOLDER_PREFIX + "lingering.xml");
        MDC.put((String)mdcKey, (String)mdcVal);
        this.logger.debug("linger 1");
        this.logger.debug(ClassicConstants.FINALIZE_SESSION_MARKER, "linger 2");
        long now = System.currentTimeMillis();
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        AppenderTracker tracker = sa.getAppenderTracker();
        Assert.assertEquals((long)1L, (long)tracker.allKeys().size());
        Appender appender = (Appender)tracker.find(mdcVal);
        Assert.assertTrue((boolean)appender.isStarted());
        tracker.removeStaleComponents(now + 10000L + 1L);
        Assert.assertFalse((boolean)appender.isStarted());
        Assert.assertEquals((long)0L, (long)tracker.allKeys().size());
    }

    @Test
    public void localPropertiesShouldBeVisible() throws JoranException {
        String mdcKey = "localProperty";
        String mdcVal = "" + this.diff;
        String msg = "localPropertiesShouldBeVisible";
        String prefix = "Y";
        this.configure(SIFT_FOLDER_PREFIX + "propertyPropagation.xml");
        MDC.put((String)mdcKey, (String)mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assert.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assert.assertEquals((long)1L, (long)listAppender.strList.size());
        Assert.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void propertyDefinedWithinSiftElementShouldBeVisible() throws JoranException {
        String mdcKey = "propertyDefinedWithinSift";
        String mdcVal = "" + this.diff;
        String msg = "propertyDefinedWithinSiftElementShouldBeVisible";
        String prefix = "Y";
        this.configure(SIFT_FOLDER_PREFIX + "propertyDefinedInSiftElement.xml");
        MDC.put((String)mdcKey, (String)mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assert.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assert.assertEquals((long)1L, (long)listAppender.strList.size());
        Assert.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void compositePropertyShouldCombineWithinAndWithoutSiftElement() throws JoranException {
        String mdcKey = "compositeProperty";
        String mdcVal = "" + this.diff;
        String msg = "compositePropertyShouldCombineWithinAndWithoutSiftElement";
        String prefix = "composite";
        this.configure(SIFT_FOLDER_PREFIX + "compositeProperty.xml");
        MDC.put((String)mdcKey, (String)mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assert.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assert.assertEquals((long)1L, (long)listAppender.strList.size());
        Assert.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void maxAppendersCountPropertyShouldBeHonored() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "maxAppenderCount.xml");
        int max = 5;
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        String mdcKey = "max";
        for (int i = 0; i <= max; ++i) {
            MDC.put((String)mdcKey, (String)("" + (this.diff + i)));
            LoggingEvent event = new LoggingEvent("", this.logger, Level.DEBUG, "max" + i, null, null);
            event.setTimeStamp((long)this.now);
            sa.doAppend((Object)event);
            this.now = (int)((long)this.now + 1000L);
        }
        AppenderTracker tracker = sa.getAppenderTracker();
        Assert.assertEquals((long)max, (long)tracker.allKeys().size());
        Assert.assertNull((Object)tracker.find("" + (this.diff + 0)));
        for (int i = 1; i <= max; ++i) {
            Assert.assertNotNull((Object)tracker.find("" + (this.diff + i)));
        }
    }

    @Test
    public void timeoutPropertyShouldBeHonored() throws JoranException, InterruptedException {
        this.configure(SIFT_FOLDER_PREFIX + "timeout.xml");
        long timeout = 30000L;
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        LoggingEvent event = new LoggingEvent("", this.logger, Level.DEBUG, "timeout", null, null);
        event.setTimeStamp((long)this.now);
        sa.doAppend((Object)event);
        AppenderTracker tracker = sa.getAppenderTracker();
        Assert.assertEquals((long)1L, (long)tracker.getComponentCount());
        this.now = (int)((long)this.now + (timeout + 1L));
        tracker.removeStaleComponents((long)this.now);
        Assert.assertEquals((long)0L, (long)tracker.getComponentCount());
        this.statusChecker.assertIsErrorFree();
    }
}

