/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.turbo.DuplicateMessageFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.junit.Assert;
import org.junit.Test;

public class DuplicateMessageFilterTest {
    @Test
    public void smoke() {
        DuplicateMessageFilter dmf = new DuplicateMessageFilter();
        dmf.setAllowedRepetitions(0);
        dmf.start();
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "x", null, null));
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "y", null, null));
        Assert.assertEquals((Object)FilterReply.DENY, (Object)dmf.decide(null, null, null, "x", null, null));
        Assert.assertEquals((Object)FilterReply.DENY, (Object)dmf.decide(null, null, null, "y", null, null));
    }

    @Test
    public void memoryLoss() {
        DuplicateMessageFilter dmf = new DuplicateMessageFilter();
        dmf.setAllowedRepetitions(1);
        dmf.setCacheSize(1);
        dmf.start();
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "a", null, null));
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "b", null, null));
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "a", null, null));
    }

    @Test
    public void many() {
        int i;
        DuplicateMessageFilter dmf = new DuplicateMessageFilter();
        dmf.setAllowedRepetitions(0);
        int cacheSize = 10;
        int margin = 2;
        dmf.setCacheSize(cacheSize);
        dmf.start();
        for (i = 0; i < cacheSize + margin; ++i) {
            Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "a" + i, null, null));
        }
        for (i = cacheSize - 1; i >= margin; --i) {
            Assert.assertEquals((Object)FilterReply.DENY, (Object)dmf.decide(null, null, null, "a" + i, null, null));
        }
        for (i = margin - 1; i >= 0; --i) {
            Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, "a" + i, null, null));
        }
    }

    @Test
    public void nullFormat() {
        DuplicateMessageFilter dmf = new DuplicateMessageFilter();
        dmf.setAllowedRepetitions(0);
        dmf.setCacheSize(10);
        dmf.start();
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, null, null, null));
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)dmf.decide(null, null, null, null, null, null));
    }
}

